/*
 * Variant.java
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 */
package dendrarium.trees.disamb;

import dendrarium.trees.svg.SVGImage;
import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Piotr Achinger <piotr.achinger at gmail.com>
 */
public class Variant implements Serializable, Cloneable {

    private String description;

    private int childrenNo;

    private int groupId;

    private String rule;

    private String comment;

    private long subtrees;

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    private boolean chosen;

    public boolean getChosen() {
        return chosen;
    }

    public void setChosen(boolean chosen) {
        this.chosen = chosen;
    }

    private boolean suggested;

    public boolean getSuggested() {
        return suggested;
    }

    public void setSuggested(boolean suggested) {
        this.suggested = suggested;
    }

    private List<ChildInfo> children;

    private SVGImage image;

    public int getChildrenNo() {
        return childrenNo;
    }

    public void setChildrenNo(int childrenNo) {
        this.childrenNo = childrenNo;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ChildInfo> getChildren() {
        return children;
    }

    public void setChildren(List<ChildInfo> children) {
        this.children = children;
    }

    public int getGroupId() {
        return groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public SVGImage getImage() {
        return image;
    }

    public void setImage(SVGImage image) {
        this.image = image;
    }

    public long getSubtrees() {
        return subtrees;
    }

    public void setSubtrees(long subtrees) {
        this.subtrees = subtrees;
    }

    public List<List<String>> getDiffAttrs() {
        List<List<String>> lists = new ArrayList();

        for (ChildInfo child : children)
            lists.add(child.getDiffAttr());

        return lists;
    }

    @Override
    public Variant clone() {
        try {
            return (Variant) super.clone();
        } catch (CloneNotSupportedException ex) {
            Logger.getLogger(Variant.class.getName()).log(Level.SEVERE,
                    "Unexpected CloneNotSupported exception caught.", ex);
            return null;
        }
    }

    public Variant(String description, int childrenNo, int groupId, String rule,
            List<ChildInfo> children, long subtrees) {
        assert description != null;
        assert rule != null;
        assert children != null;
        
        this.description = description;
        this.childrenNo = childrenNo;
        this.groupId = groupId;
        this.rule = rule;
        this.children = children;
        this.subtrees = subtrees;
        this.suggested = false;
        this.chosen = false;
    }

    public Variant() {
        this("[null]", 0, 0, "[null]", new ArrayList<ChildInfo>(), 0);
    }
}
