package dendrarium.trees.disamb;

import java.util.Comparator;
import java.util.TreeMap;
import org.jboss.seam.log.Log;


/**
 *
 * @author axw
 */
public class VariantComparator implements Comparator<Variant> {

    public static TreeMap<String, Integer> wagiLabeli;
    
    public Log log;
    
    public VariantComparator() {

        wagiLabeli = new TreeMap<String, Integer>();
        wagiLabeli.put("wypowiedzenie", 10);
        wagiLabeli.put("zdanie", 11);
        wagiLabeli.put("ff", 12);
        wagiLabeli.put("fw", 13);
        wagiLabeli.put("fl", 14);
        wagiLabeli.put("fwe", 15);
        wagiLabeli.put("fno", 16);
        wagiLabeli.put("fpm", 17);
        wagiLabeli.put("fpt", 18);
        wagiLabeli.put("fzd", 19);
        wagiLabeli.put("fps", 20);
        wagiLabeli.put("flicz", 21);
        wagiLabeli.put("zaimos", 22);
        wagiLabeli.put("zaimrzecz", 23);
        wagiLabeli.put("formarzecz", 24);
        wagiLabeli.put("formalicz", 25);
        wagiLabeli.put("formaprzym", 26);
        wagiLabeli.put("formaczas", 27);
        wagiLabeli.put("przyzlo", 28);
        wagiLabeli.put("condaglt", 29);
        wagiLabeli.put("przyimek", 30);
        wagiLabeli.put("spójnik", 31);
        wagiLabeli.put("partykuła", 32);
        wagiLabeli.put("przec", 33);
        wagiLabeli.put("znakkonca", 34);
        wagiLabeli.put("zaimprzym", 35);
        wagiLabeli.put("formaprzys", 36);
        wagiLabeli.put("formaczas1", 37);
        wagiLabeli.put("cudz", 38);
        wagiLabeli.put("fpmpt", 39);
        wagiLabeli.put("korelat", 40);
        wagiLabeli.put("nawias", 41);
        wagiLabeli.put("pauza", 42);
        wagiLabeli.put("spoj1", 43);
    }
    
    @Override
    public int compare(Variant v1, Variant v2) {

        //log.info("compare variants ");
        //System.out.println("compare variants ");

        if (!(v1 instanceof Variant) || !(v2 instanceof Variant) )
            throw new ClassCastException("GroupMap: not variant objects, as expected");


        // w pierwszej kolejnosci te z mniejsza liczba skladnikow
        if (v1.getChildren().size() <  v2.getChildren().size()) return -1;
        else
        if (v1.getChildren().size() >  v2.getChildren().size()) return 1;
        else {
        // tyle samo skladnikow

            // dluzszy kawalek na poczatku jako pierwszy
            for (int position=0; position < v1.getChildren().size() ; position++ ) {
                if (v1.getChildren().get(position).getSubSentence().size() >
                    v2.getChildren().get(position).getSubSentence().size() ) return -1;
                if (v1.getChildren().get(position).getSubSentence().size() <
                    v2.getChildren().get(position).getSubSentence().size() ) return 1;
            }

            // porównanie symboli nieterminalnych
            for (int position=0; position < v1.getChildren().size() ; position++ ) {
                String label1 = v1.getChildren().get(position).getLabel();
                String label2 = v2.getChildren().get(position).getLabel();
                int waga_1 = (wagiLabeli.containsKey(label1) ? wagiLabeli.get(label1) : 1000);
                int waga_2 = (wagiLabeli.containsKey(label2) ? wagiLabeli.get(label2) : 1000);
                if (waga_1 > waga_2) return 1;
                if (waga_1 < waga_2) return -1;
                /* jeśli obie są nieznane, to porównujemy leksykograficznie */
                if (waga_1 == 1000 && waga_2 == 1000) {
                    if (label1.compareTo(label2) > 0)
                        return 1;
                    else
                        return -1;
                }
            }

        // sortowanie po regule, leksykograficznie:
        if ( v1.getRule().compareTo(v2.getRule()) < 0 ) return -1;
        else
        if ( v1.getRule().compareTo(v2.getRule()) > 0 ) return 1;

	}

        return 1;
    }
}
