package dendrarium.trees.svg;

import dendrarium.trees.NonterminalNode.ChoiceType;

/**
 *
 * @author Tomasz Badowski
 */
public class DrawConfig {
    static private Integer textFontSize = 40;
    static private Integer textVertDistance = (textFontSize*4)/3; /* Odleglosc
     w pionie linii tekstu w tabelce na dole */
    static private Integer ruleFontSize = 34;
    static private Integer textFontWidth = (textFontSize * 8)/13;
    static private Integer smallFontWidth = (textFontSize * 2)/5;
    static private Integer middleFontWidth = (textFontSize * 6)/13;

    static private Integer pillowSize = (textFontSize * 1)/3; /* szerokosc pustej
     otoczki tekstu w wezle */
    static private Integer tableColumnPillow = (textFontWidth )/2; /* szerokosc
    przerw po bokach tekstu w tabelce na dole */
    static private Integer levelSize = 150;
    static private String textFontFamily = "Verdana";
    static private String fillColor = "yellow";
    static private String strokeColor = "black";
    static private String disambFillColor = "pink";
    static private String disambStrokeColor = "red";
    static private String noCorrectChildrenFillColor = "red";
    static private String noCorrectChildrenStrokeColor = "black";
    static private String nontermLeafFillColor = "greenyellow";
    static private String nontermLeafStrokeColor = " black";
    static private String nontermInteractLeafFillColor = "orange";
    static private String nontermInteractLeafStrokeColor = " black";
    static private String textColor = "black";
    static private String disambTextColor = "black";
    static private Integer virtualToReal=120;   /* Przez co podzielić rozmiar
            wirtualny by otrzymać rozmiar rzeczywisty */
    static private String  lineStroke = "black";
    static private Integer lineStrokeWidth = 2;

    /* parametry malych drzewek - wariantow */
    static private Integer variantVirtualToReal = 100;   /* Przez co podzielić rozmiar
    wirtualny by otrzymać rzeczywisty */
    static private String varTriangleColor = "peachpuff";
    static private String varTriangleStrokeColor = "lightsalmon";


    /**
     * @return the textFontSize
     */
    static public Integer getTextFontSize() {
        return textFontSize;
    }

    /**
     * @return the textFontWidth
     */
    static public Integer getTextFontWidth() {
        return textFontWidth;
    }

    /**
     * @return the levelSize
     */
    static public Integer getLevelSize() {
        return levelSize;
    }

    /**
     * @return the textFontFamily
     */
    static public String getTextFontFamily() {
        return textFontFamily;
    }

    /**
     * @return the fillColor
     */
    public static String getFillColor() {
        return fillColor;
    }

    /**
     * @return the strokeColor
     */
    public static String getStrokeColor() {
        return strokeColor;
    }

    /**
     * @return the ruleFontSize
     */
    public static Integer getRuleFontSize() {
        return ruleFontSize;
    }

    /**
     * @return the textColor
     */
    public static String getTextColor() {
        return textColor;
    }

    /**
     * @return the disambTextColor
     */
    public static String getDisambTextColor() {
        return disambTextColor;
    }

    /**
     * @return the virtualToReal
     */
    public static Integer getVirtualToReal() {
        return virtualToReal;
    }

    /**
     * @return the disambFillColor
     */
    public static String getDisambFillColor() {
        return disambFillColor;
    }


    /**
     * @return the disambStrokeColor
     */
    public static String getDisambStrokeColor() {
        return disambStrokeColor;
    }

    /**
     * @return the lineStroke
     */
    public static String getLineStroke() {
        return lineStroke;
    }

    /**
     * @return the lineColor
     */
    public static Integer getLineStrokeWidth() {
        return lineStrokeWidth;
    }

    /**
     * @return the textVertDistance
     */
    public static Integer getTextVertDistance() {
        return textVertDistance;
    }

    /**
     * @param aTextVertDistance the textVertDistance to set
     */
    public static void setTextVertDistance(Integer aTextVertDistance) {
        textVertDistance = aTextVertDistance;
    }

    public static Integer getPillowSize() {
        return pillowSize;
    }

    /**
     * @author ks
     */
    public static String getFillColorByChoiceType (ChoiceType choiceType) {
        if (choiceType == null)
            return "grey";
        switch (choiceType) {
            case MANY_CHILDREN_ONE_SUGGESTED:
                return "orange";
            case USER_SUGGESTED:
                return "greenyellow";
            case USER_NOT_SUGGESTED:
                return "skyblue";
            case NONE:
                return "lavender";
            case TERMINAL:
                return "#9CA7D4";
            case ONE_SUGGESTED_CHILD:
                return "wheat";
            case ONE_NOT_SUGGESTED_CHILD:
                return "yellow";
            default:
                return "yellow";
        }
    }

    /**
     * @return the nontermLeafFillColor
     */
    public static String getNontermLeafFillColor() {
        return nontermLeafFillColor;
    }

    /**
     * @return the nontermLeafStrokeColor
     */
    public static String getNontermLeafStrokeColor() {
        return nontermLeafStrokeColor;
    }

    /**
     * @param aNontermLeafStrokeColor the nontermLeafStrokeColor to set
     */
    public static void setNontermLeafStrokeColor(String aNontermLeafStrokeColor) {
        nontermLeafStrokeColor = aNontermLeafStrokeColor;
    }

    /**
     * @return the variantVirtualToReal
     */
    public static Integer getVariantVirtualToReal() {
        return variantVirtualToReal;
    }

    /**
     * @return the varTriangleColor
     */
    public static String getVarTriangleColor() {
        return varTriangleColor;
    }

    /**
     * @return the varTriangleStrokeColor
     */
    public static String getVarTriangleStrokeColor() {
        return varTriangleStrokeColor;
    }

    /**
     * @return the tableColumnPillow
     */
    public static Integer getTableColumnPillow() {
        return tableColumnPillow;
    }

    /**
     * @return the noCorrectChildrenFillColor
     */
    public static String getNoCorrectChildrenFillColor() {
        return noCorrectChildrenFillColor;
    }

    /**
     * @return the noCorrectChildrenStrokeColor
     */
    public static String getNoCorrectChildrenStrokeColor() {
        return noCorrectChildrenStrokeColor;
    }

    /**
     * @return the nontermInteractLeafFillColor
     */
    public static String getNontermInteractLeafFillColor() {
        return nontermInteractLeafFillColor;
    }

    /**
     * @param aNontermInteractLeafFillColor the nontermInteractLeafFillColor to set
     */
    public static void setNontermInteractLeafFillColor(String aNontermInteractLeafFillColor) {
        nontermInteractLeafFillColor = aNontermInteractLeafFillColor;
    }

    /**
     * @return the nontermInteractLeafStrokeColor
     */
    public static String getNontermInteractLeafStrokeColor() {
        return nontermInteractLeafStrokeColor;
    }

    static int getSmallFontWidth() {
        return smallFontWidth;
    }

    /**
     * @return the middleFontWidth
     */
    public static Integer getMiddleFontWidth() {
        return middleFontWidth;
    }

    /**
     * @return the varTextFontSize
     */
   

}