package dendrarium.utils;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

/**
 * Pomocnicze funkcje rozszerzajace EL oraz zarzadzajace wlasciwosciami
 * z pliku dendrarium.properties.
 *
 * Funkcje nalezy zarejestrowac w pliku WEB-INF/dendrarium.taglib.xml
 *
 * @author Piotr Achinger
 */
public class ELHelper {

    /**
     * Konkatenacja stringow (nie ma domyslnie w EL)
     */
    public static String concat(String s1, String s2) {
        return s1 + s2;
    }

    /**
     * Sciezka korzenia aplikacji
     */
    public static String root() {
        return FacesContext.getCurrentInstance().getExternalContext().
                getRequestContextPath();
    }

    /**
     * Zamienia znak konca linii na html BR
     */
    public static String entery(String s) {
        return s.replace("\n", "<br/>\n").replace("\t", "    ").replace(" ", "&#160;");
    }

    public static String tlo(Boolean b) {
        if (b) {
            return "background: url(/Dendrarium/img/stripes.gif) 0 0 repeat";
        } else {
            return "background: #DBD4C6";
        }
    }

    public static String stat(String i) {
        return ("0".equals(i) || "NaN".equals(i)) ? "-" : i;
    }

    private static Properties properties;

    public static final String PROPERTIES_FILE = "/dendrarium/dendrarium.properties";

    /**
     * Pobiera wartosc zmiennej konfiguracyjnej
     */
    public static String property(String name) {
        if (properties == null) {
            loadProperties();
        }
        return properties.getProperty(name, "");
    }

    /**
     * Pobiera wartosc zmiennej konfiguracyjnej indeksowanej (name_index)
     */
    public static String indexedProperty(String name, String index) {
        if (properties == null) {
            loadProperties();
        }
        return properties.getProperty(name + "_" + index, "?");
    }

    private static void loadProperties() {
        properties = new Properties();
        try {
            properties.load(ELHelper.class.getResourceAsStream(PROPERTIES_FILE));
        } catch (IOException ex) {
            Logger.getLogger(ELHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}
