package dendrarium.utils;

import java.io.Serializable;

/**
 * Klasa reprezentuje parę dwóch klas dowolnych typów.
 * 
 * @author Piotr Tabor
 */
public class Pair<F1, F2> implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private F1 f1;

	private F2 f2;

	public Pair(F1 a_f1, F2 a_f2) {
		f1 = a_f1;
		f2 = a_f2;
	}

	public Pair<F2, F1> rotate() {
		return new Pair<F2, F1>(f2, f1);
	}

	public F1 getF1() {
		return f1;
	}

	public void setF1(F1 f1) {
		this.f1 = f1;
	}

	public F2 getF2() {
		return f2;
	}

	public void setF2(F2 f2) {
		this.f2 = f2;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean equals(Object arg0) {
		if (arg0 == null)
			return false;
		if (Pair.class.isInstance(arg0)) {
			try {
				Pair<F1, F2> p2 = (Pair<F1, F2>) arg0;
				return (f1 == null ? p2.f1 == null : f1.equals(p2.f1))
                        && (f1 == null ? p2.f1 == null : f1.equals(p2.f1)) ;

			} catch (ClassCastException e) {
				return false;
			}
		} else
			return false;
	}

	@Override
	public int hashCode() {
		int res = 0;
		if (f1 != null)
			res += f1.hashCode();
		if (f2 != null)
			res += 3 * f2.hashCode();
		return res;
	}

}
