/*
 * StringUtils.java
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 */

package dendrarium.utils;

/**
 * Pomocnicze operacje na stringach
 * 
 * @author Piotr Achinger <piotr.achinger at gmail.com>
 */
public class StringUtils {

    public static String join(Object[] objs, String seperator) {
        int length = objs.length;
        if (length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer().append(objs[0]);
        for (int i = 1; i < length; i++) {
            buf.append(seperator).append(objs[i]);
        }
        return buf.toString();
    }

    public static String truncate(int max, String string) {
        if (string.length() > max) {
            return string.substring(0, max);
        } else {
            return string;
        }
    }
}
