/*
 * XMLUtils.java
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 */
package dendrarium.utils;

import dendrarium.trees.svg.TreeDrawer;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/**
 *
 * @author Piotr Achinger <piotr.achinger at gmail.com>
 */
public class XMLUtils {

    public static Document parseXML(InputStream is) throws Exception {

        DocumentBuilderFactory docBuilderFactory =
                               DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder;
        Document doc;
        try {
            docBuilderFactory.setValidating(false);
            docBuilderFactory.setXIncludeAware(false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);

            docBuilder = docBuilderFactory.newDocumentBuilder();
        } catch (ParserConfigurationException ex) {
            throw new Exception("Unable to start indexing: " + ex);
        }

        try {
            doc = docBuilder.parse(is);
        } catch (SAXException ex) {
            //Logger.getLogger(MethodConfigManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new Exception("Problem with parsing XML in input source: " +
                    is, ex);
        } catch (IOException ex) {
            //Logger.getLogger(MethodConfigManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new Exception("Problem with reading input source: " +
                    is, ex);
        }

        // normalize text representation
        doc.getDocumentElement().normalize();

        /* --- */
        return doc;
    }

    /**
     * pta
     */
    public static byte[] writePrettyByteArrayJDOM(org.jdom.Document doc) {
        try {
            ByteArrayOutputStream out;
            out = new ByteArrayOutputStream();
            XMLOutputter xmlOut = new XMLOutputter(Format.getPrettyFormat());
            xmlOut.output(doc, out);
            out.flush();
            out.close();
            return out.toByteArray();
        } catch (IOException ex) {
            Logger.getLogger(TreeDrawer.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void writePrettyFileJDOM(String fname, org.jdom.Document doc) {
        try {
            FileOutputStream out;
            out = new FileOutputStream(fname);
            XMLOutputter xmlOut = new XMLOutputter(Format.getPrettyFormat());
            xmlOut.output(doc, out);
            out.flush();
            out.close();
        } catch (IOException ex) {
            Logger.getLogger(TreeDrawer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//end writePrettyFile

    public static String getElementText(Element element) {
        if (element.getChildNodes().getLength() == 0) {
            return "";
        }

        return ((Text) element.getChildNodes().item(0)).getWholeText();
    }
}
