/*
 * toggle.js
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 */

function toggleVisibility(id) {
    if (document.getElementById(id).style.visibility == 'hidden') {
        makeVisible(id)
    } else {
        makeInvisible(id)
    }
}

function makeVisible(id) {
    document.getElementById(id).style.visibility = 'visible'
    document.getElementById(id).style.display = 'inline'
}

function makeInvisible(id) {
    document.getElementById(id).style.visibility = 'hidden'
    document.getElementById(id).style.display = 'none'
}

function centerScrollBar(d, x, y) {
    if (x > 0) {
        d.scrollLeft = x;
    } else {
        d.scrollLeft = 0;
    } 
    if (y > 0) {
        d.scrollTop = y;
    } else {
        d.scrollTop = 0;
    }
}

function truncateScrollHeight(d, min) {
    if (d.scrollHeight < min) {
        d.offsetHeight = d.scrollHeight;
        d.clientHeight = d.scrollHeight;
        d.style.height = d.scrollHeight + "px";
    }
}