/*
 * Przystosowuje las do schematu ktorego oczekuje viewer.js
 * viewer.js bedzie wywolywac rozne funkcje z tego pliku w miare potrzeby
 */

function helper_prepare(forest) {
	/* Wezel rozstrzygany potrzebuje dodatkowego miejsca na znak
	 * zapytania */
	if ("disamb_node_id" in forest &&
			forest.node[forest.disamb_node_id].leaf)
		forest.node[forest.disamb_node_id].space = 0.4;

	/* Terminale nie sa wyswietlane */
	function hide_terminals(node) {
		node = forest.node[node.nid];

		if (node.terminal) {
			node.hidden = true;
			return;
		}
		if (node.leaf)
			node.incomplete = true;
		if (!node.children)
			return;

		for (var c in node.children)
			for (var ch in node.children[c].child)
				hide_terminals(node.children[c].child[ch]);
	}
	hide_terminals(forest.startnode);
}

function helper_nodecopy(node) {
	var newnode = {};
	for (var i in node)
		newnode[i] = node[i];
	return newnode;
}

function helper_get_subtree(tree, n, diffattrs) {
	/* Can't use \w -- Firefox seems to only understand ascii */
	diffattrs = eval(diffattrs.replace(/[^[\] ,]+/gi, "\"$&\""));
	var subtree = {};
	for (var i in tree)
		subtree[i] = tree[i];

	subtree.stats = eval(uneval(subtree.stats));
	subtree.node = {};

	var node = helper_nodecopy(tree.node[subtree.disamb_node_id]);
	var child = node.children[n].child;
	node.hidden = true;
	node.incomplete = false;
	node.leaf = false;
	node.children = [ {
			head:  node.children[n].head,
			"child": [],
			rule:  node.children[n].rule,
		} ];
	node.current = 0;
	if ("space" in node)
		delete node["space"];

	subtree.node[node.id] = node;
	subtree.stats.trees = node.subtrees;
	subtree.startnode = node;

	for (var i in child) {
		var nid = child[i].nid;
		var subnode = helper_nodecopy(tree.node[nid]);

		subnode.hidden = !!subnode.terminal;
		subnode.incomplete = !subnode.terminal/* && !(
			subnode.children[0].child.length == 1 &&
			subnode.children[0].child[0].terminal)*/;
		subnode.leaf = true;
		subnode.show_attribs = true;
		subnode.diffattrs = {};
		for (var j in diffattrs[i])
			subnode.diffattrs[diffattrs[i][j]] = true;

		delete subnode.children;
		subtree.node[nid] = subnode;
		node.children[0].child.push(subnode);
	}

	return subtree;
}

function helper_update_node_info(node, onover, onout, onwheel, onswitch,
		add_attr_spans, nopopup) {
	var text = node.terminal ? "\"" + node.terminal.base + "\"" :
			node.nonterminal.category;
	node.info.innerHTML = "";

	var inactive = node.inactive || (node.orig != undefined &&
			node.orig != node.current && node.chtype);
	node.elem = document.createElement("div");
	node.elem.innerHTML = text.to_xml_safe();
	node.elem.className = inactive ? "inactive-node" :
		node.terminal ? "terminal-node" :
		!node.chtype ? "one-non-suggested-node" :
		node.chtype == 1 ? "unresolved-node" :
		node.chtype == 2 ? "many-suggested-node" :
		node.chtype == 3 ? "one-suggested-node" :
		node.chtype == 4 ? "user-suggested-node" :
		"user-non-suggested-node";
	if ("target" in node)
		node.elem.className += " link";
	if (node.selected) {
		node.elem.className += " nonterminal-node-active";
		node.info.className += " nonterminal-node-active";
	}
	node.elem.className += " nodecontent";

	var m = document.createElement("div");
	m.className = "middle";
	m.appendChild(node.elem);
	node.info.appendChild(m);

	if (!node.show_attribs) {
		attach(node.elem, "mouseover", onover, false);
		attach(node.elem, "mouseout", onout, false);
	}

	if ("target" in node)
		attach(node.elem, "mousedown", function(evt) {
					nopopup();
					var id = "main:accessibleNodes:" +
						node.target + ":nodebutton";
					document.getElementById(id).click();
				}, false);

	if (!node.hidden && !node.incomplete && node.children) {
		var rulename = "";
		if (node.children[node.current].rule)
			rulename =
				node.children[node.current].rule.to_xml_safe();

		if (node.orig == undefined)
			node.orig = node.current;

		for (var chld in node.children[node.current].child)
			node.children[node.current].child[chld].inactive =
				inactive;

		var rule = document.createElement("span");
		rule.className = "rule";

		if (node.current) {
			var img = document.createElement("img");
			img.setAttribute("src", "img/gtk-left.png");
			img.setAttribute("width", "12");
			img.setAttribute("height", "12");
			img.onclick = function() {
				onswitch(-1);
			};

			rule.appendChild(img);
		}

		rule.appendChild(document.createTextNode(rulename));

		if (node.current < node.children.length - 1) {
			var img = document.createElement("img");
			img.setAttribute("src", "img/gtk-right.png");
			img.setAttribute("width", "12");
			img.setAttribute("height", "12");
			img.onclick = function() {
				onswitch(1);
			};

			rule.appendChild(img);
		}

		m.appendChild(rule);

		attach(rule, "DOMMouseScroll", onwheel, false);
	}

	if (node.show_attribs)
		helper_fill_node_attributes(node, add_attr_spans);

	if (!node.selected || !node.leaf)
		return;

	node.info.appendChild(document.createElement("br"));
	node.info.appendChild(document.createElement("br"));
	var q = document.createElement("span");
	q.className = "q";
	q.innerHTML = "?";
	node.info.appendChild(q);
	attach(q, "mouseover", onover, false);
	attach(q, "mouseout", onout, false);
}

function helper_update_ruler_info(n) {
	var html;
	if (n.terminal)
		html = n.terminal.orth.to_xml_safe();
	else if (n.leaf) {
		html = "";

		var prev = 0;
		var p = (n.centre.length > 1) ? (1.0 / n.centre.length) :
			n.show_attribs ? 0.7 : 1.0;
		for (var i = 0; i < n.orth.length; i ++) {
			var sep = "";
			var orth = n.orth[i].to_xml_safe();
			if (orth[0] == " ") {
				if (i)
					sep = " ";
				orth = orth.substr(1);
			}

			var start = i + n.from;
			var count = 0;
			for (seg in n.centre)
				if (start >= n.centre[seg][0] &&
						start < n.centre[seg][1])
					count ++;

			if (count > prev)
				html += sep;
			if (count != prev) {
				if (prev)
					html += "</span>";
				if (count)
					html += "<span style=\"background: " +
						"rgba(255, 255, 255, " +
						(p * count) + ");\">";
			}
			if (count <= prev)
				html += sep;
			html += orth;

			prev = count;
		}
		if (prev)
			html += "</span>";
	} else
		html = "Błąd";
	if (n.terminal)
		html += "<br />" + n.terminal.base.to_xml_safe();
	if (n.attrs.tag)
		html += "<br />" + n.attrs.tag.to_xml_safe();

	n.ruler_span.innerHTML = html;
}

var s = [ "<span class=\"value\">", "</span>" ];
function helper_popup_info(node, popup, forest) {
	var link = document.createElement("a");
	link.innerHTML = "&lt;&lt; Szczegóły";
	link.className = "moreinfo";

	var para = document.createElement("p");
	para.appendChild(link);
	para.className = "moreinfo";
	popup.appendChild(document.createElement("br"));
	popup.appendChild(para);
	popup.className = "moreinfo";

	link.onclick = function(evt) {
		popup.removeChild(para);
		para.innerHTML = "";
		para.className = "";

		popup.appendChild(document.createElement("hr"));
		var section = document.createElement("h3");
		section.style.fontStyle = "italic";
		if (node.nonterminal)
			popup.appendChild(section);
		popup.appendChild(para);

		var html = "";
		html += node.terminal ?
				("Terminal " + s[0] +
				 node.terminal.orth + s[1]) :
				("Nieterminal " + s[0] +
				 node.nonterminal.category + s[1]);
		html += "<br />";

		html += "ID węzła: " + s[0] + node.nid + s[1];
		html += "<br />";

		if (node.nonterminal && !node.leaf) {
			html += "Wyprowadzony regułą " + s[0] +
				node.children[node.current].rule + s[1];
			html += "<br />";

			if (node.children.length > 5)
				html += "(możliwe " +
					(node.children.length - 1) +
					" innych sposobów wyprowadzenia)";
			else if (node.children.length > 2)
				html += "(możliwe " +
					(node.children.length - 1) +
					" inne sposoby wyprowadzenia)";
			else if (node.children.length > 1)
				html += "(możliwy 1 inny sposób wyprowadzenia)";
			else
				html += "(jednoznacznie)";
			html += "<br />";

			if (node.chtype == 1) {
				html += "Węzeł do rozstrzygnięcia";
				html += "<br />";
			} else {
				if (node.children.length > 1) {
					html += "Wybór " +
						((node.chtype == 4 ||
						  node.chtype == 5) ?
						 "dokonany przez użytkownika" :
						 "automatyczny");
					html += "<br />";
				}

				if (node.chtype == 2 || node.chtype == 3 ||
						node.chtype == 4) {
					html += "Wybór sugerowany";
					html += "<br />";
				}
			}

			html += "Wersja gramatyki: " + s[0] +
				forest.data.grammar_no + s[1];
			html += "<br />";
		} else if (node.nonterminal) {
			html += "Węzeł do rozstrzygnięcia";
		} else if (node.terminal) {
			html += "Forma podstatowa: " + s[0] +
				node.terminal.base + s[1];
			html += "<br />";

			html += "Interp_id: " + s[0] +
				node.terminal.interp_id + s[1];
			html += "<br />";
		}

		para.innerHTML = html;

		if (node.terminal)
			return;

		var set_section = function(sections) {
			for (var s in sections)
				for (var n in sections[s])
					if (node.nonterminal.category ==
							sections[s][n])
						section.innerHTML = s;
		}
		var set_rule = function(rules) {
			var rule = new RegExp("\\bs\\(" +
				node.children[node.current].rule + "\\)");
			var num = -1;
			for (var i in rules)
				if (rules[i].match(rule)) {
					num = i;
					break;
				}
			if (num == -1)
				return;
			para.innerHTML += "Treść reguły:<br /><pre>" +
				rules[num].to_xml_safe() + "</pre>";
		}
		gfjp_load("sections", "gfjp", set_section);
		gfjp_load("rules", "rules", set_rule);
	}
}

function helper_fill_node_attributes(node, add_attr_spans) {
	node.elem.appendChild(document.createElement("hr"));

	var attrs = node.elem.appendChild(document.createElement("table"));
	attrs.className = "attr-table";
	for (var n in node.attrs_order) {
		var name = node.attrs_order[n];
		var row = attrs.insertRow(-1);

		var attrdiv = document.createElement("div");
		var valdiv = document.createElement("div");

		add_attr_spans(attrdiv, name);
		add_attr_spans(valdiv, name, node.attrs[name]);

		row.insertCell(0).appendChild(attrdiv);
		row.insertCell(1).appendChild(valdiv);
		row.cells[0].className = "attr-name";

		if (name in node.diffattrs)
			row.className = "attr-diff";
	}
	node.elem.appendChild(attrs);
}

var gfjp = {};
function gfjp_load(field, file, cb) {
	if (gfjp[field]) {
		cb(gfjp[field]);
		return;
	}

	gfjp.watch(field, function(prop, oldval, newval) {
				cb(newval);
				gfjp.unwatch(field);
				return newval;
			});

	var node = document.createElement("script");
	node.setAttribute("type", "text/javascript");
	node.setAttribute("src", "js/" + file + ".js");
	document.body.appendChild(node);
	if (!window.opera && window.navigator.userAgent.indexOf("WebKit") == -1)
		document.body.removeChild(node); /* Clean-up (?) */
}

function helper_after_loaded(forest) {
	if (!forest.blackboard || forest.rule)
		return;

	var rulename = "";
	var node = forest.startnode;
	if (node.children[0].rule)
		rulename = node.children[0].rule.to_xml_safe();

	forest.rule = document.createElement("span");
	forest.rule.className = "rule rule-choice";
	forest.rule.innerHTML = rulename;
	forest.blackboard.appendChild(forest.rule);
}

function helper_before_unload(forest) {
	if (!forest.blackboard || !forest.rule)
		return;
	forest.blackboard.removeChild(forest.rule);
	delete forest["rule"];
}

var tree_helpers = {
	"prepare": helper_prepare,
	"update_node_info": helper_update_node_info,
	"update_ruler_info": helper_update_ruler_info,
	"popup_info": helper_popup_info,
};

var subtree_helpers = {
	"update_node_info": helper_update_node_info,
	"update_ruler_info": helper_update_ruler_info,
	"after_loaded": helper_after_loaded,
	"before_unload": helper_before_unload,
	"popup_info": helper_popup_info,
};

var fulltree = null;
var helper_load = null;

function helper_loaded_full_subtree(num, viewer, button) {
	if (viewer.subtree_loaded)
		return;

	var subtree = {};
	for (var i in fulltree)
		subtree[i] = fulltree[i];

	subtree.stats = eval(uneval(subtree.stats));

	var node = helper_nodecopy(subtree.node[current_tree.disamb_node_id]);
	node.hidden = true;
	node.current = num;

	subtree.node[node.id] = node;
	subtree.stats.trees = node.subtrees;
	subtree.startnode = node;
	subtree.copy = true;

	viewer.orig_data = viewer.data;
	viewer.data = "";
	viewer.helper = tree_helpers;
	viewer.data = subtree;
	viewer.subtree_loaded = true;

	button.value = "Ukryj pełne poddrzewo";
	button.disabled = "";
}

function helper_load_full_subtree(url, num, obj, button) {
	if (obj.subtree_loaded) {
		obj.data = "";
		obj.subtree_loaded = false
		obj.helper = subtree_helpers;
		obj.data = obj.orig_data;
		delete obj.orig_data;

		button.value = "Pokaż pełne poddrzewo";
		button.disabled = "";
		return;
	}

	button.value = "Ładowanie…";
	button.disabled = "disabled";

	if (fulltree == null) {
		fulltree = -1;

		var node = document.createElement("script");
		node.setAttribute("type", "text/javascript");
		node.setAttribute("src", url);

		helper_load = function(result) {
			fulltree = result;
			helper_loaded_full_subtree(num, obj, button);

			document.body.removeChild(node); /* Clean-up (?) */
		}
		document.body.appendChild(node);
	}

	if (fulltree == -1)
		return;

	helper_loaded_full_subtree(num, obj, button);
}

function clean_up() {
	var emptyarray = new Array();
	for (var element in emptyarray)
		delete Array.prototype[element];
}
clean_up();
