/*
Copyright (c) 2012, Bartłomiej Nitoń
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

$(function() {
   $('form.new-account-form').live('submit', new_account_form_submit);  
   $('#change-user-function').load(ajax_change_user_fun_form, 'user_id=', function(){
     $('#change-user-function #id_user').live('change', user_changed);      
     $('#change-user-function #user-delete').live('click', delete_user);
   }); 
   $('form.user-function-form').live('submit', user_function_form_submit);
});



function user_changed()
{
   user_id = $('#change-user-function #id_user').val();
   $('#change-user-function').empty();
   $('#change-user-function').load(ajax_change_user_fun_form, 'user_id='+user_id, function(){
    // $('#change-user-function #id_user').live('change', user_changed);      
   }); 
}

function new_account_form_submit() {
    ShowProgressAnimation();
    this_form = $(this);
    form_data = this_form.serializeArray();
  
    form_data = $.map(form_data, function(elem)
    {
      if (elem.name != 'group' && elem.name != 'username' &&
         elem.name != 'password1' && elem.name != 'password2' && 
         elem.name != 'email')
        return elem;
      else {
        if (elem.name == 'group')
          group = elem.value;
        else if (elem.name == 'username')
          username = elem.value;
        else if (elem.name == 'password1')
          password1 = elem.value;
        else if (elem.name == 'password2')
          password2 = elem.value;
        else if (elem.name == 'email')
          email = elem.value;
      }
    });

	form_data.push({name: 'group', value: group});
    form_data.push({name: 'username', value: username});
    form_data.push({name: 'email', value: email});
    form_data.push({name: 'password1', value: password1});
    form_data.push({name: 'password2', value: password2});

    $.ajaxJSON({
      method: 'post',
      url: ajax_new_account_form_submit,
      data: {
        form_data: form_data
      },

    callback: function(result) {
      $('#change-user-function').load(ajax_change_user_fun_form, 'user_id=', function(){
       // $('#change-user-function #id_user').live('change', user_changed);      
      });
      resetForm($('.new-account-form'));
      HideProgressAnimation();
    },
    error_callback: function(xhr, status, error) {
      HideProgressAnimation();
      error_alert(status + ': ' + error);
      //if (ctrl)
      //  ctrl.remove();
    },
    bad_data_callback: function(result) {
      //if (ctrl)
      //  ctrl.remove();
      if (result == 'empty fields') {
        HideProgressAnimation();
        error_alert('Wszystkie pola formularza muszą zostać wypełnione.');
        return false;
      }
      else if (result == 'wrong e-mail form')
      {
        HideProgressAnimation();
        error_alert('Nieprawidłowa forma maila.');
        return false;
      }
      else if (result == 'passwords not match')
      {
        HideProgressAnimation();
        error_alert('Podane hasła nie są zgodne.');
        return false;
      }
      else if (result == 'invalid username')
      {
        HideProgressAnimation();
        error_alert('Podana nazwa użytkownika jest niewłaściwa.');
        return false;
      }
      else if (result == 'invalid password')
      {
        HideProgressAnimation();
        error_alert('Podane hasło jest niewłaściwe.');
        return false;
      } 
      else if (result == 'user exist')
      {
        HideProgressAnimation();
        error_alert('Użytkownik o podanej nazwie już istnieje.');
        return false;
      }
      else
      {
        HideProgressAnimation();
        return true;
      }
    },
  });
  return false;
}

function user_function_form_submit() {
    ShowProgressAnimation();
    this_form = $(this);
    form_data = this_form.serializeArray();
  
    form_data = $.map(form_data, function(elem)
    {
      if (elem.name != 'user' && elem.name != 'group')
        return elem;
      else {
        if (elem.name == 'group')
          group = elem.value;
        else if (elem.name == 'user')
          user = elem.value;
      }
    });

	form_data.push({name: 'group', value: group});
    form_data.push({name: 'user', value: user});

    $.ajaxJSON({
      method: 'post',
      url: ajax_change_user_fun_form_submit,
      data: {
        form_data: form_data
      },

    callback: function(result) {
      $('#change-user-function').load(ajax_change_user_fun_form, 'user_id=', function(){
       // $('#change-user-function #id_user').live('change', user_changed);      
      });
      HideProgressAnimation();
    },
    error_callback: function(xhr, status, error) {
      HideProgressAnimation();
      error_alert(status + ': ' + error);
      //if (ctrl)
      //  ctrl.remove();
    },
    bad_data_callback: function(result) {
      //if (ctrl)
      //  ctrl.remove();
      if (result == 'empty fields') {
        HideProgressAnimation();
        error_alert('Wszystkie pola formularza muszą zostać wypełnione.');
        return false;
      }
      else if (result == 'is superuser')
      {
        HideProgressAnimation();
        error_alert('Nie mo࠮a modyfikowa桰raw superu࠹tkownika.');
        return false;
      }
      else
      {
        HideProgressAnimation();
        return true;
      }
    },
  });
  return false;
}

function delete_user() {
  ShowProgressAnimation();
  user_id = $('#change-user-function #id_user').val();

  $.ajaxJSON({
    method: 'post',
    url: ajax_delete_user,
    data: {
      user_id: user_id
    },

    callback: function(result) {
      $('#change-user-function').load(ajax_change_user_fun_form, 'user_id=', function(){
       // $('#change-user-function #id_user').live('change', user_changed);      
      });
      HideProgressAnimation();
    },
    
    error_callback: function(xhr, status, error) {
      HideProgressAnimation();
      error_alert(status + ': ' + error);
      //if (ctrl)
      //  ctrl.remove();
    },
    bad_data_callback: function(result) {
      //if (ctrl)
      //  ctrl.remove();
      if (result == 'user not selected') {
        HideProgressAnimation();
        error_alert('Wybierz u�ytkownika, kt�rego chcesz usun��.');
        return false;
      }
      else if (result == 'is superuser')
      {
        HideProgressAnimation();
        error_alert('Nie mo�na usun�� superu�ytkownika.');
        return false;
      }
      else if (result == 'deleting own account')
      {
        HideProgressAnimation();
        error_alert('Ogarnij si�!');
        return false;
      }
      else
      {
        HideProgressAnimation();
        return true;
      }
    },
  });
  return false;
}