#-*- coding:utf-8 -*-

#Copyright (c) 2012, Bartłomiej Nitoń
#All rights reserved.

#Redistribution and use in source and binary forms, with or without modification, are permitted provided 
#that the following conditions are met:

#    Redistributions of source code must retain the above copyright notice, this list of conditions and 
#    the following disclaimer.
#    Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
#    and the following disclaimer in the documentation and/or other materials provided with the distribution.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.

from django.conf.urls.defaults import *

from common.util import url
from django.conf import settings

# Uncomment the next two lines to enable the admin:
from django.contrib import admin
admin.autodiscover()

urlpatterns = patterns('',
  # Example:
  # (r'^cesar/', include('cesar.foo.urls')),
  url(r'^accounts/settings/$', 'accounts.views.settings', name='settings'),
  (r'^accounts/', include('registration.urls')),
  
  # testowe


  url(r'^ajax/sort_rules/$', 'dictionary.ajax_jqgrid.sort_rules',
      name='sort_rules'),
      
  # downloadowanie slownikow
  (r'^slowniki/(.+)/$', 'dictionary.ajax_lemma_view.download_vocabulary'),

  # Uncomment the admin/doc line below and add 'django.contrib.admindocs'
  # to INSTALLED_APPS to enable admin documentation:
  # (r'^admin/doc/', include('django.contrib.admindocs.urls')),

  # Uncomment the next line to enable the admin:
  (r'^admin/', include(admin.site.urls)),

  url(r'^%s(?P<path>.*)$' % settings.MEDIA_URL.lstrip('/'),
      'django.views.static.serve',
      kwargs={'document_root': settings.MEDIA_ROOT}),
)

urlpatterns += patterns('dictionary.ajax_lemma_view',
                        
# lemma view
  url(r'^ajax/lemmas/$', 'get_lemmas'),
  url(r'^ajax/old_frames/$', 'get_old_frames'),
  url(r'^ajax/new_frames/$', 'get_new_frames'),
  url(r'^ajax/change_ctrl/$', 'get_change_ctrl'),
  url(r'^ajax/lemma_examples/$', 'get_lemma_examples'),
  url(r'^ajax/lemma_status/$', 'get_lemma_status'),
  url(r'^ajax/lemma_notes/$', 'get_lemma_notes'), 
  url(r'^ajax/lemma_preview/$', 'get_lemma_preview'),
  
  url(r'^ajax/get_note_text/$', 'get_note_text'),
  url(r'^ajax/lemma_notes_form_submit/$', 'lemma_notes_form_submit'),
  url(r'^ajax/lemma_status_change/$', 'lemma_status_change'),
  url(r'^ajax/position_form/$', 'position_form'),
  url(r'^ajax/argument_form/$', 'argument_form'),
  url(r'^ajax/argument_form_submit/$', 'argument_form_submit'),
  url(r'^ajax/save_new_frames/$', 'save_new_frames'),
  url(r'^ajax/restore_lemma/$', 'restore_lemma'),
  url(r'^ajax/position_lookup/$', 'position_lookup'),
  url(r'^ajax/argument_lookup/$', 'argument_lookup'),
  url(r'^ajax/get_ctrl_preview/$', 'get_ctrl_preview'),
  url(r'^ajax/add_position/$', 'add_position'),
  url(r'^ajax/frame_form/$', 'frame_form'),
  url(r'^ajax/frame_form_submit/$', 'frame_form_submit'),
  url(r'^ajax/pos_cat_form/$', 'pos_cat_form'),
  url(r'^ajax/pos_cat_form_submit/$', 'pos_cat_form_submit'),
  url(r'^ajax/nkjp_example_form_submit/$', 'nkjp_example_form_submit'),
  url(r'^ajax/can_confirm_example/$', 'can_confirm_example'),
  url(r'^ajax/confirm_nkjp_example/$', 'confirm_nkjp_example'),
  url(r'^ajax/location/$', 'get_location'),  
  url(r'^ajax/remove_lemma_note/$', 'remove_lemma_note'),
  url(r'^ajax/lemma_note_form/$', 'lemma_note_form'),
  url(r'^ajax/get_lemma_note/$', 'get_lemma_note'),
  url(r'^ajax/lemma_notes_modify/$', 'lemma_notes_modify'),
  
  # sortowanie, filtrowanie, ukrywanie kolumn tabeli
  url(r'^ajax/sort_form/$', 'sort_form'),
  url(r'^ajax/filter_form/$', 'filter_form'),
  url(r'^ajax/sort_form_submit/$', 'sort_form_submit'),
  url(r'^ajax/filter_form_submit/$', 'filter_form_submit'),
  url(r'^ajax/sort_column/$', 'sort_column'),
  url(r'^ajax/save_columns/$', 'save_columns'),
  url(r'^ajax/get_sort_order/$', 'get_sort_order'),
  
  # czasowniki podobne
  url(r'^ajax/similar_lemmas_old_form_submit/$', 'similar_lemmas_old_form_submit'),
  url(r'^ajax/similar_lemmas_new_form_submit/$', 'similar_lemmas_new_form_submit'),
  url(r'^ajax/similar_lemmas_reset/$', 'similar_lemmas_reset'),
  url(r'^ajax/preview_select/$', 'preview_select'),
  #walidacja
  url(r'^ajax/validate_new_frames/$', 'validate_new_frames'),
  # modyfikacja przykladow nkjp
  url(r'^ajax/get_nkjp_dict_ids/$', 'get_nkjp_dict_ids'),
  
# user notes
  url(r'^ajax/remove_note/$', 'remove_note'),
  url(r'^ajax/get_lemma_from_note/$', 'get_lemma_from_note'),
  url(r'^ajax/note_session_clear/$', 'note_session_clear'),
  url(r'^ajax/note_session_get/$', 'note_session_get'),
  
# slowniki
  url(r'^ajax/create_vocabulary/$', 'create_vocabulary'),
  url(r'^ajax/vocab_perm_manage_form/$', 'vocab_perm_manage_form'),
  url(r'^ajax/vocab_perm_manage_form_submit/$', 'vocab_perm_manage_form_submit'),
  url(r'^ajax/lemma_lookup/$', 'lemma_lookup'),
  url(r'^ajax/lemma_add_form_submit/$', 'lemma_add_form_submit'),
  url(r'^ajax/get_vocabulary_stats/$', 'get_vocabulary_stats'),
  url(r'^ajax/delete_lemma/$', 'delete_lemma'),
  
# statystyki uzytkonikow
  url(r'^ajax/get_user_stats/$', 'get_user_stats'),
  
# zarzadzanie kontami
  url(r'^ajax/new_account_form_submit/$', 'new_account_form_submit'),
  url(r'^ajax/change_user_fun_form/$', 'change_user_fun_form'),
  url(r'^ajax/change_user_fun_form_submit/$', 'change_user_fun_form_submit'),
  url(r'^ajax/delete_user/$', 'delete_user'),
  
# argument realizations
  url(r'^ajax/realization_arg_form/$', 'realization_arg_form'),
  url(r'^ajax/add_arg_realization/$', 'add_arg_realization'),
  url(r'^ajax/show_realizations/$', 'show_realizations'),
  url(r'^ajax/remove_realization/$', 'remove_realization'),
)

urlpatterns += patterns('dictionary.views',
  url(r'^$', 'lemma_view'),
  url(r'^notatki/$', 'user_notes'),  
  url(r'^slowniki/$', 'manage_vocabulary'),
  url(r'^statystyki/$', 'user_statistics'),
  url(r'^wszystkie_statystyki/$', 'all_statistics'),
  url(r'^zarzadzanie_kontami/$', 'manage_users'),
  url(r'^dodawanie_realizacji/$', 'manage_arg_realizations'),
)
