#-*- coding:utf-8 -*-

#Copyright (c) 2012, Bartłomiej Nitoń
#All rights reserved.

#Redistribution and use in source and binary forms, with or without modification, are permitted provided 
#that the following conditions are met:

#    Redistributions of source code must retain the above copyright notice, this list of conditions and 
#    the following disclaimer.
#    Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
#    and the following disclaimer in the documentation and/or other materials provided with the distribution.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.

from django.db.models import *
from django.contrib.auth.models import User, Group
from dictionary.models import Message

MANAGER_GROUPS = ('Gość', 'Leksykograf', 'Superleksykograf')

def manager_groups():
  return Group.objects.filter(name__in=MANAGER_GROUPS)

class UserSettings(Model):
  user = OneToOneField(User, related_name='user_settings') # tutaj, dodano related_name
  incremental_search = BooleanField(
    default=False, # zmieniono default na false
    verbose_name=u'wyszukiwanie przyrostowe',
    help_text=u'Wyszukiwanie odbywa się automatycznie w miarę wpisywania '
              u'szukanego hasła. Sugerujemy wyłączenie w wypadku wolnego '
              u'połączenia internetowego.')
  filter_search = BooleanField(
    default=True,
    verbose_name=u'wyszukiwanie przez filtrowanie',
    help_text=u'Wyszukiwanie powoduje zawężenie listy haseł do pasujących '
              u'do zapytania.')

  def has_new_messages(self):
    lemmas_new_msg = self.user.lemmas.filter(messages__new=True).filter(messages__private=False)
    if len(lemmas_new_msg) > 0:
      return True;
    return False; 

  def new_notes_number(self):
    new_notes = Message.objects.filter(lemma__owner=self.user, private=False, new=True)   
    return len(new_notes) 

  def change_all_lemmas(self):
    return self.user.has_perm('dictionary.change_all_lemmas')

  def view_lemma(self):
    return self.user.has_perm('dictionary.view_lemma')

  def view_notes(self):
    return self.user.has_perm('dictionary.view_notes')

  def add_notes(self):
    return self.user.has_perm('dictionary.add_notes')

  def change_lemmas(self):
    return self.user.has_perm('dictionary.change_lemmas')

  def change_lemma_status(self):
    return self.user.has_perm('dictionary.change_lemma_status')

  def manages_vocabulary(self):
    return self.user.has_perm('dictionary.manage_vocabulary')
  
  class Meta:
    permissions = (
      ('create_admin', u'Może nadawać dowolne role'),
    )

def filtering_mode(user):
  return user.usersettings.filter_search
