#-*- coding:utf-8 -*-

#Copyright (c) 2012, Bartłomiej Nitoń
#All rights reserved.

#Redistribution and use in source and binary forms, with or without modification, are permitted provided 
#that the following conditions are met:

#    Redistributions of source code must retain the above copyright notice, this list of conditions and 
#    the following disclaimer.
#    Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
#    and the following disclaimer in the documentation and/or other materials provided with the distribution.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.

from django.contrib import admin
from models import *

class LemmaAdmin(admin.ModelAdmin):    
    filter_horizontal = ('old_frames', 'frames',)
        #list_display   = ('title', 'publisher', 'publication_date')
    search_fields  = ('entry',)
    list_filter    = ('old', 'vocabulary',)
        #ordering       = ('-publication_date',)
    
class FrameAdmin(admin.ModelAdmin):    
    filter_horizontal = ('positions',)
    search_fields  = ('text_rep',)
    
class PositionAdmin(admin.ModelAdmin):    
    filter_horizontal = ('arguments',)
    
class ArgumentAdmin(admin.ModelAdmin):    
    filter_horizontal = ('atributes',)
    
class Atribute_ModelAdmin(admin.ModelAdmin):    
    filter_horizontal = ('atribute_values',)
    
class CompatibilityClassAdmin(admin.ModelAdmin):
    filter_horizontal = ('comp_lemmas',)
    
class NKJP_ArgSelectionAdmin(admin.ModelAdmin):
    filter_horizontal = ('arguments',)
    
class NKJP_ExampleAdmin(admin.ModelAdmin):
    filter_horizontal = ('arguments',)
    list_filter    = ('source', 'opinion',)


admin.site.register(Vocabulary)
admin.site.register(Lemma, LemmaAdmin)
admin.site.register(Frame, FrameAdmin)
admin.site.register(NKJP_Example, NKJP_ExampleAdmin)
admin.site.register(Dendrarium_Example)
admin.site.register(Position, PositionAdmin)
admin.site.register(PositionCategory)
admin.site.register(Argument, ArgumentAdmin)
admin.site.register(Argument_Model)    
admin.site.register(Atribute_Value)
admin.site.register(Atribute_Model, Atribute_ModelAdmin)
admin.site.register(Atribute)
admin.site.register(Old_Frame)      
admin.site.register(Frame_Characteristic)
admin.site.register(Frame_Char_Model)
admin.site.register(Frame_Char_Value)
admin.site.register(Message)
admin.site.register(Change)
admin.site.register(CompatibilityClass, CompatibilityClassAdmin)
admin.site.register(NKJP_ArgSelection, NKJP_ArgSelectionAdmin)

admin.site.register(NKJP_Source)
admin.site.register(NKJP_Opinion)
admin.site.register(Configuration)
admin.site.register(VocabularyFormat)
admin.site.register(Frame_Opinion)

