#-*- coding:utf-8 -*-

#Copyright (c) 2012, Bartłomiej Nitoń
#All rights reserved.

#Redistribution and use in source and binary forms, with or without modification, are permitted provided 
#that the following conditions are met:

#    Redistributions of source code must retain the above copyright notice, this list of conditions and 
#    the following disclaimer.
#    Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
#    and the following disclaimer in the documentation and/or other materials provided with the distribution.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.

from django.contrib.auth.models import Permission, Group
from django.core.management.base import BaseCommand, CommandError
import django.contrib.auth

class Command(BaseCommand):
    args = 'none'
    help = 'Creates default groups'

    def handle(self, **options):
      create_groups()


def get_permission(codename):
  return Permission.objects.get(codename=codename)

def create_groups():
  Group.objects.all().delete()
  guests = Group.objects.create(name=u'Gość')
  lexicographers = Group.objects.create(name=u'Leksykograf')
  superlexicographers = Group.objects.create(name=u'Superleksykograf')
  admins = Group.objects.create(name=u'Administrator')

# prawa gosci
  guests.permissions.add(get_permission('view_lemma'))
  guests.permissions.add(get_permission('add_notes'))
  
# prawa leksykografow
  lexicographers.permissions.add(get_permission('view_lemma'))
  lexicographers.permissions.add(get_permission('add_notes'))
  lexicographers.permissions.add(get_permission('view_notes'))
  lexicographers.permissions.add(get_permission('change_lemmas'))
  lexicographers.permissions.add(get_permission('see_stats'))

# prawa superleksykografow
  superlexicographers.permissions.add(get_permission('view_lemma'))
  superlexicographers.permissions.add(get_permission('add_notes'))
  superlexicographers.permissions.add(get_permission('view_notes'))
  superlexicographers.permissions.add(get_permission('change_all_lemmas'))
  superlexicographers.permissions.add(get_permission('change_lemmas'))
  superlexicographers.permissions.add(get_permission('confirm_lemma'))  
  superlexicographers.permissions.add(get_permission('manage_vocabulary'))
  superlexicographers.permissions.add(get_permission('see_stats'))
  superlexicographers.permissions.add(get_permission('see_all_stats'))
  superlexicographers.permissions.add(get_permission('add_user'))
  superlexicographers.permissions.add(get_permission('create_realization'))
  superlexicographers.permissions.add(get_permission('confirm_example'))
  superlexicographers.permissions.add(get_permission('manage_tool_configuration'))
  #superlexicographers.permissions.add(get_permission('view_pattern'))
