#-*- coding:utf-8 -*-

#Copyright (c) 2012, Bartłomiej Nitoń
#All rights reserved.

#Redistribution and use in source and binary forms, with or without modification, are permitted provided 
#that the following conditions are met:

#    Redistributions of source code must retain the above copyright notice, this list of conditions and 
#    the following disclaimer.
#    Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
#    and the following disclaimer in the documentation and/or other materials provided with the distribution.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR 
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.

from django.core.management.base import NoArgsCommand
from django.contrib.auth.models import User

from dictionary.models import *

DEFAULT_OLD_DICT_PATH = 'data/s_czas_sdpv'

class Command(NoArgsCommand):
    help = 'Import models dependencies to tool.'

    def handle_noargs(self, **options):
        print u'Importing models to database. Please wait.'
        import_models()


def import_models():
    import_frame_char_models()
    #import_argument_models() # Tutaj, stare
    import_new_argument_models() # Tutaj, nowe
    import_position_cats()
    import_lemma_statuses()
    import_frame_opinions()
    import_nkjp_sources_dict()
    import_nkjp_opinion_dict()
    import_old_frame_properties()
    import_vocabulary_formats()
    create_tool_configuration()

def create_tool_configuration():
    Configuration(name=u'globalna', example_approvers_num=2, selected_conf=True).save()

def import_old_frame_properties():
    Old_Frame_Property(name=u'V', value=u'verb', priority=10).save()
    Old_Frame_Property(name=u'Q', value=u'quasi-verb', priority=20).save()
    
def import_vocabulary_formats():
    VocabularyFormat(format=u'Tekstowy', priority=10).save()
    VocabularyFormat(format=u'PDF', priority=20).save()
    
def import_lemma_statuses():
    Lemma_Status.objects.all().delete()
    
    Lemma_Status(status=u'do obróbki', validate=False, check_examples=False, priority=10).save()
    Lemma_Status(status=u'w obróbce',  validate=False, check_examples=False, priority=20).save()
    Lemma_Status(status=u'gotowe',     validate=True,  check_examples=False, priority=30).save()
    Lemma_Status(status=u'sprawdzone', validate=True,  check_examples=True, priority=40).save()

def import_frame_opinions():
    Frame_Opinion_Value.objects.all().delete()
    
   # Frame_Opinion_Value(value=u' ',          priority=0).save()
    Frame_Opinion_Value(value=u'pewna',      priority=10).save()
    Frame_Opinion_Value(value=u'wątpliwa',   priority=20).save()
    Frame_Opinion_Value(value=u'zła',        priority=30).save()
    Frame_Opinion_Value(value=u'archaiczna', priority=40).save()
    Frame_Opinion_Value(value=u'potoczna',   priority=50).save()
    

def import_nkjp_sources_dict():
    NKJP_Source.objects.all().delete()
    
    NKJP_Source(source=u'podkorpus zrównoważony NKJP (300M segmentów)', priority=10, comment_required=False, confirmation_required=False).save()
    NKJP_Source(source=u'pełny NKJP (1800M segmentów)', priority=20, comment_required=False, confirmation_required=False).save()
    NKJP_Source(source=u'demo NKJP (wersja 2; 500M segmentów)', priority=30, comment_required=False, confirmation_required=False).save()
    NKJP_Source(source=u'korpus ręcznie anotowany (1.2M segmentów)', priority=40, comment_required=False, confirmation_required=False).save()
    NKJP_Source(source=u'pełny Korpus IPI PAN (2. wydanie; 250M segmentów)', priority=50, comment_required=False, confirmation_required=False).save()
    NKJP_Source(source=u'próbka Korpusu IPI PAN (2. wydanie; 30M segmentów)', priority=60, comment_required=False, confirmation_required=False).save()
    NKJP_Source(source=u'Korpus Słownika Frekwencyjnego (0,5M segmentów)', priority=70, comment_required=False, confirmation_required=False).save()
    NKJP_Source(source=u'literatura lingwistyczna', priority=80, comment_required=True, confirmation_required=False).save()
    NKJP_Source(source=u'literatura inna', priority=90, comment_required=True, confirmation_required=False).save()
    NKJP_Source(source=u'własny', priority=100, comment_required=False, confirmation_required=True).save()
    
def import_nkjp_opinion_dict():
    NKJP_Opinion.objects.all().delete()
    
  #  NKJP_Opinion(opinion=u' ',          priority=0).save()
    NKJP_Opinion(opinion=u'dobry',      priority=10).save()
    NKJP_Opinion(opinion=u'wątpliwy',   priority=20).save()
    NKJP_Opinion(opinion=u'zły',        priority=30).save()
    
    
def import_frame_char_models():
    # usuwanie informacji o charakterystykach ramek z bazy danych
    Frame_Char_Model.objects.all().delete()
    Frame_Char_Value.objects.all().delete()
    
    # dokonanosc
    aspect = Frame_Char_Model(model_name=u'ASPEKT', priority=10)
    aspect.save()
    
    atr_val = Frame_Char_Value(value=u'imperf',  priority=10) # niedokonany
    atr_val.save()
    aspect.frame_char_values.add(atr_val)
    atr_val = Frame_Char_Value(value=u'perf',   priority=20) # dokonany
    atr_val.save()
    aspect.frame_char_values.add(atr_val)
    atr_val = Frame_Char_Value(value=u'_',   priority=30) # dokonany lub niedokonany
    atr_val.save()
    aspect.frame_char_values.add(atr_val)   
    
    # zwrotnosc
    reflex = Frame_Char_Model(model_name=u'ZWROTNOŚĆ', priority=20)
    reflex.save()
    
    atr_val = Frame_Char_Value(value=u'',   priority=10) # bez "się"
    atr_val.save()
    reflex.frame_char_values.add(atr_val)   
    atr_val = Frame_Char_Value(value=u'się',  priority=20) # z "się"
    atr_val.save()
    reflex.frame_char_values.add(atr_val)
    atr_val = Frame_Char_Value(value=u'_',  priority=30) # z "się" i bez "się"
    atr_val.save()
    reflex.frame_char_values.add(atr_val)
    
def import_position_cats():
    # czyszczenie zawartosci tabeli definiujacej kategorie pozycji
    PositionCategory.objects.all().delete()
    
    # wypelnianie madrosci o kategoriach pozycji
    PositionCategory(category='subj',        priority=10, control=False).save()
    PositionCategory(category='obj',         priority=20, control=False).save()
    PositionCategory(category='controller',  priority=30, control=True).save()
    PositionCategory(category='controlee',   priority=40, control=True).save()
    #PositionCategory(category='pred', priority=30).save()
   


#################################################################################

    # wypelnianie tabel definiujacych modele argumentow pozycji
def import_new_argument_models():
    # czyszczenie zawartosci tabel definiujacych wzory atrybutow i mozliwe
    # do przyjecia wartosci atrybutow
    Argument_Model.objects.all().delete()
    Atribute_Model.objects.all().delete()
    Atribute_Value.objects.all().delete()
    
    # 'PRZYIMEK'
    preposition = Atribute_Model(atr_model_name=u'PRZYIMEK', text_atribute=False, priority=10)
    preposition.save()
    # 'PRZYIMEK1' o nizszym priorytecie dla comprepnp
    preposition1 = Atribute_Model(atr_model_name=u'PRZYIMEK1', text_atribute=False, priority=120)
    preposition1.save()
    # przyimek 'co do'
    atr_val = Atribute_Value(value=u'co do', priority=1000, realization_only=False) 
    atr_val.save()
    preposition.atribute_values.add(atr_val)
    preposition1.atribute_values.add(atr_val)

    # PRZYPADEK, PRZYPADEK 1 o nizszym priorytecie dla comprepnp
    case = Atribute_Model(atr_model_name=u'PRZYPADEK', text_atribute = False, priority=20)
    case.save()
    case1 = Atribute_Model(atr_model_name=u'PRZYPADEK1', text_atribute = False, priority=130)
    case1.save()
    
    atr_val = Atribute_Value(value=u'str',   priority=10, realization_only=False) # przypadek strukturalny
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'pred',  priority=20, realization_only=False) # przypadek predykatywny
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'part', priority=30, realization_only=False) # przypadek partytywny/czastkowy
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'nom',  priority=40, realization_only=False) # mianownik
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'dat',  priority=50, realization_only=False) # celownik
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'acc',  priority=60, realization_only=False) # biernik
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'gen',  priority=70, realization_only=False) # dopełniacz
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'inst',  priority=80, realization_only=False) # narzednik
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'loc',  priority=90, realization_only=False) # miejscownik
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'postp',  priority=100, realization_only=False) # przypadek poprzyimkowy
    atr_val.save()
    case.atribute_values.add(atr_val)
    case1.atribute_values.add(atr_val)
    
    # TYP FRAZY
    phrase_type = Atribute_Model(atr_model_name=u'TYP FRAZY', text_atribute = False, priority=30)
    phrase_type.save()

 # definiowanie wartosci atrybutow dla typow frazy    
    atr_val = Atribute_Value(value=u'że',    priority=110, realization_only=False)  # fraza zdaniowa ze spójnikiem ˙ze, iz
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'żeby',    priority=120, realization_only=False) # fraza zdaniowa ze spójnikiem ˙zeby, aby, by
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'żeby2',     priority=130, realization_only=False) # fraza zdaniowa oznajmujaca, w ograniczonym 
    atr_val.save()                                              # kontekscie dopuszczajaca rowniez spojnik typu zeby
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'int',   priority=140, realization_only=False) # fraza zdaniowa ze spójnikiem czy
    atr_val.save()                                                                 # bylo intrel
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'czy', priority=150, realization_only=False)  # fraza pytajno-zalezna, z elementem takim jak kto, co, itd.
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)   
    atr_val = Atribute_Value(value=u"jeśli",    priority=160, realization_only=False) # fraza zdaniowa ze spójnikiem az
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'gdy',    priority=170, realization_only=False) # fraza zdaniowa ze spójnikiem jesli
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'kiedy',    priority=180, realization_only=False) # fraza zdaniowa ze spójnikiem jesli
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'aż',    priority=190, realization_only=False) # fraza zdaniowa ze spójnikiem jesli
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'jakoby',    priority=200, realization_only=False) # fraza zdaniowa ze spójnikiem jesli
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'jakby',    priority=210, realization_only=False) # fraza zdaniowa ze spójnikiem jesli
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'jak',    priority=220, realization_only=False) # fraza zdaniowa ze spójnikiem jesli
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    
    atr_val = Atribute_Value(value=u'gdzie',    priority=220, realization_only=True) 
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'skąd',    priority=220, realization_only=True) 
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'dokąd',    priority=220, realization_only=True) 
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'którędy',    priority=220, realization_only=True) 
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'zanim',    priority=220, realization_only=True) 
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'aż2',    priority=220, realization_only=True) 
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'dopóki',    priority=220, realization_only=True) 
    atr_val.save()
    phrase_type.atribute_values.add(atr_val)    

    # LICZBA 
    number = Atribute_Model(atr_model_name=u'LICZBA', text_atribute = False, priority=40)
    number.save()
    
    atr_val = Atribute_Value(value=u'sg', priority=230, realization_only=False) # liczba pojedyncza
    atr_val.save()
    number.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'pl', priority=240, realization_only=False) # liczba mnoga
    atr_val.save()
    number.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'_',  priority=250, realization_only=False) # dowolna
    atr_val.save()
    number.atribute_values.add(atr_val)
    
    # 'LEMAT'
    lemma = Atribute_Model(atr_model_name=u""'LEMAT'"", text_atribute=True, priority=50)
    lemma.save()
    
    # MODYFIKACJA
    modification = Atribute_Model(atr_model_name=u'MODYFIKACJA', text_atribute = False, priority=60)
    modification.save()
    
    atr_val = Atribute_Value(value=u'natr', priority=260, realization_only=False) # brak mozliwosci modyfikacji (no attribute)
    atr_val.save()
    modification.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'atr',  priority=270, realization_only=False) # mozliwa modyfikacja
    atr_val.save()
    modification.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'ratr', priority=280, realization_only=False) # wymagany atrybut (dierzawczy) (required attribute)
    atr_val.save()
    modification.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'batr', priority=290, realization_only=False) # wymagany atrybut swój lub własny (bound attribute)
    atr_val.save()
    modification.atribute_values.add(atr_val)
    
    # ASPEKT
    aspect = Atribute_Model(atr_model_name=u'ASPEKT', text_atribute = False, priority=70)
    aspect.save()
    
    atr_val = Atribute_Value(value=u'dk',  priority=300, realization_only=False) # dokonany
    atr_val.save()
    aspect.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'ndk', priority=310, realization_only=False) # niedokonany
    atr_val.save()
    aspect.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'_',   priority=320, realization_only=False) # dowolny
    atr_val.save()
    aspect.atribute_values.add(atr_val)
    
    # KATEGORIA
    category = Atribute_Model(atr_model_name=u'KATEGORIA', text_atribute = False, priority=80)
    category.save()
    
    atr_val = Atribute_Value(value=u'_',   priority=330, realization_only=False) # dowolny
    atr_val.save()
    category.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'locat',   priority=340, realization_only=False) # miejsce
    atr_val.save()
    category.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'abl',    priority=350, realization_only=False) # punkt poczatkowy
    atr_val.save()
    category.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'adl',    priority=360, realization_only=False) # punkt koncowy
    atr_val.save()
    category.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'perl',  priority=370, realization_only=False) # trasa
    atr_val.save()
    category.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'temp',   priority=380, realization_only=False) # czas
    atr_val.save()
    category.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'dur',  priority=390, realization_only=False) # dlugosc trwania
    atr_val.save()
    category.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'mod',  priority=400, realization_only=False) # sposob
    atr_val.save()
    category.atribute_values.add(atr_val)
    #atr_val = Atribute_Value(value=u'caus',  priority=410) # przyczyna
    #atr_val.save()
    #category.atribute_values.add(atr_val)
    #atr_val = Atribute_Value(value=u'dest',  priority=420) # cel
    #atr_val.save()
    #category.atribute_values.add(atr_val)
    
    # KATEGORIA advp
    category_advp = Atribute_Model(atr_model_name=u'KATEGORIA_ADVP', text_atribute = False, priority=90)
    category_advp.save()
    
    atr_val = Atribute_Value(value=u'pron',   priority=410, realization_only=False) # dowolny
    atr_val.save()
    category_advp.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'misc',   priority=420, realization_only=False) # miejsce bylo deg
    atr_val.save()
    category_advp.atribute_values.add(atr_val)
    
    atr_val = Atribute_Value(value=u'locat',   priority=430, realization_only=True) # miejsce
    atr_val.save()
    category_advp.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'abl',   priority=440, realization_only=True) # punkt poczatkowy
    atr_val.save()
    category_advp.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'adl',   priority=450, realization_only=True) # punkt koncowy
    atr_val.save()
    category_advp.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'perl',   priority=460, realization_only=True) # trasa
    atr_val.save()
    category_advp.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'temp',   priority=470, realization_only=True) # czas
    atr_val.save()
    category_advp.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'dur',   priority=480, realization_only=True) # dlugosc trwania
    atr_val.save()
    category_advp.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'mod',   priority=490, realization_only=True) # sposob
    atr_val.save()
    category_advp.atribute_values.add(atr_val)
   
   # atr_val = Atribute_Value(value=u'_',   priority=430) # dowolny
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'locat',   priority=440) # miejsce
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'ablocat',    priority=450) # punkt poczatkowy
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'adlocat',    priority=460) # punkt koncowy
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'perl',  priority=470) # trasa
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'temp',   priority=480) # czas
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'dur',  priority=490) # dlugosc trwania
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'mod',  priority=500) # sposob
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'caus',  priority=510) # przyczyna
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'dest',  priority=520) # cel
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
   # atr_val = Atribute_Value(value=u'tak',  priority=530) # tak
   # atr_val.save()
   # category_advp.atribute_values.add(atr_val)
    
    # 'TRESC'
    content = Atribute_Model(atr_model_name=u"\'TREŚĆ\'", text_atribute=True, priority=100)
    content.save()
    
    # SHORT
    short = Atribute_Model(atr_model_name=u"SKRÓT", text_atribute=False, priority=110)
    short.save()
    
    atr_val = Atribute_Value(value=u'z powodu',   priority=500, realization_only=False) # dowolny
    atr_val.save()
    short.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'w sprawie',   priority=510, realization_only=False) # dowolny
    atr_val.save()
    short.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'co do',   priority=520, realization_only=False) # dowolny
    atr_val.save()
    short.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'na temat',   priority=530, realization_only=False) # dowolny
    atr_val.save()
    short.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'w kwestii',   priority=540, realization_only=False) # dowolny
    atr_val.save()
    short.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'w roli',   priority=550, realization_only=False) # dowolny
    atr_val.save()
    short.atribute_values.add(atr_val)
    atr_val = Atribute_Value(value=u'na rzecz',   priority=560, realization_only=False) # dowolny
    atr_val.save()
    short.atribute_values.add(atr_val)

    
######################## Wzory argumentow ##################################
    # np(PRZYPADEK) 
    arg_model = Argument_Model(arg_model_name=u'np', priority=10, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(case)
    
    # adjp(PRZYPADEK)
    arg_model = Argument_Model(arg_model_name=u'adjp', priority=20, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(case)
    
    # prepnp('PRZYIMEK',PRZYPADEK)
    arg_model = Argument_Model(arg_model_name=u'prepnp', priority=30, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(preposition, case)
    
    # prepadjp('PRZYIMEK',PRZYPADEK)
    arg_model = Argument_Model(arg_model_name=u'prepadjp', priority=40, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(preposition, case)
    
    # compprepnp('SHORT')
    arg_model = Argument_Model(arg_model_name=u'comprepnp', priority=50, realization_only=False, has_realizations=True)
    arg_model.save()
    arg_model.atribute_models.add(short)
    
    # cp(TYP FRAZY)
    arg_model = Argument_Model(arg_model_name=u'cp', priority=60, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(phrase_type)
    
    # ncp(PRZYPADEK,TYP FRAZY)
    arg_model = Argument_Model(arg_model_name=u'ncp', priority=70, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(case, phrase_type)
    
    # prepncp('PRZYIMEK',PRZYPADEK,TYP FRAZY)
    arg_model = Argument_Model(arg_model_name=u'prepncp', priority=80, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(preposition, case, phrase_type)
    
    # nonch
    arg_model = Argument_Model(arg_model_name=u'nonch', priority=90, realization_only=False, has_realizations=False)
    arg_model.save()  
    
    # infp(ASPEKT)
    arg_model = Argument_Model(arg_model_name=u'infp', priority=100, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(aspect)
    
    # xp(KATEGORIA)
    arg_model = Argument_Model(arg_model_name=u'xp', priority=110, realization_only=False, has_realizations=True)
    arg_model.save()
    arg_model.atribute_models.add(category)
    
    # advp
    arg_model = Argument_Model(arg_model_name=u'advp', priority=120, realization_only=False, has_realizations=False)
    arg_model.save()  
    arg_model.atribute_models.add(category_advp)
    
    # lexnp(PRZYPADEK,'LEMAT',LICZBA,MODYFIKACJA)
    arg_model = Argument_Model(arg_model_name=u'lexnp', priority=130, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(case, number, lemma, modification)
    
    # preplexnp('PRZYIMEK',PRZYPADEK,LICZBA,'LEMAT',MODYFIKACJA)
    arg_model = Argument_Model(arg_model_name=u'preplexnp', priority=140, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(preposition, case, number, lemma, modification)
    
    # lp(KATEGORIA)
    arg_model = Argument_Model(arg_model_name=u'lp', priority=150, realization_only=False, has_realizations=True)
    arg_model.save()
    arg_model.atribute_models.add(category)
    
    # fixed('TREŚĆ')
    arg_model = Argument_Model(arg_model_name=u'fixed', priority=160, realization_only=False, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(content) 
    
    # or
    arg_model = Argument_Model(arg_model_name=u'or', priority=170, realization_only=False, has_realizations=False)
    arg_model.save()
    
    # refl
    arg_model = Argument_Model(arg_model_name=u'refl', priority=180, realization_only=False, has_realizations=False)
    arg_model.save() 
    
    # comprepnp1(’PRZYIMEK’,PRZYPADEK,LICZBA,’LEMAT’)
    arg_model = Argument_Model(arg_model_name=u'comprepnp1', priority=190, realization_only=True, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(preposition, case, number, lemma)
    
    # comprepnp2(’PRZYIMEK’,PRZYPADEK,LICZBA,’LEMAT’,PRZYPADEK)
    arg_model = Argument_Model(arg_model_name=u'comprepnp2', priority=200, realization_only=True, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(preposition, case, number, lemma, case1)
    
    # comprepnp3(’PRZYIMEK’,PRZYPADEK,LICZBA,’LEMAT’,’PRZYIMEK’,PRZYPADEK)
    arg_model = Argument_Model(arg_model_name=u'comprepnp3', priority=210, realization_only=True, has_realizations=False)
    arg_model.save()
    arg_model.atribute_models.add(preposition, case, number, lemma, preposition1, case1)  
    
    # E - epsilon, argument pusty
    arg_model = Argument_Model(arg_model_name=u'E', priority=220, realization_only=False, has_realizations=False)
    arg_model.save()
      