/*
Copyright (c) 2012, Bartłomiej Nitoń
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

$(function() {

  window.selected_notes_row_id = -1;
 
  function selectNotesTr(id)
  {  	  
  	if(selected_notes_row_id != -1)
  	{
  	  var recent_row = document.getElementById(selected_notes_row_id);
  	  var recent_descendants = getDescendantsNodes(recent_row);
  	  for(var i = 0; i<recent_descendants.length; i++)
  	    $(recent_descendants[i]).css("background-color", "");
  	}
  	
  	if(selected_notes_row_id == id)
  	  selected_notes_row_id = -1;
  	else
  	{
  	  selected_notes_row_id = id;
  	  var row = document.getElementById(id);
  	  var descendants = getDescendantsNodes(row);
  	  for(var i = 0; i<descendants.length; i++)
  	    $(descendants[i]).css("background-color", "LightSteelBlue");
  	  message_id = id.replace('note_', '');
  	  
  	  $('#lemma_note_text').load(ajax_get_note_text, 'id='+message_id, function(){
        $('#'+id+' td#new').text('   ');
        get_lemma_from_note(id);
      });	  
  	}
  }
  
function delete_user_note(id) {
	if(id == -1)
	{
	  alert('Zaznacz notatkę aby ją usunąć.');
	  return false;
	}
	
	message_id = id.replace('note_', '');
	
    $.ajaxJSON({
      method: 'post',
      url: ajax_remove_note,
      data: {
        message_id: message_id
      },

    callback: function(result) {      
		$('#'+id).remove();
		$('#lemma_note_text').empty();
		selected_notes_row_id = -1;
    },
    error_callback: function(xhr, status, error) {
      error_alert(status + ': ' + error);
      //if (ctrl)
      //  ctrl.remove();
    },
    bad_data_callback: function(result) {
      //if (ctrl)
      //  ctrl.remove();
      if (result == 'can not remove') {
        error_alert('Usuwa� mo�na jedynie notatki prywatne.');
        return false;
      }
      
      else
        return true;
    },
  });
  return false;
}

function get_lemma_from_note(id)
{  	
	// znajdz identyfikator hasla do ktorego dodano notatke
	message_id = id.replace('note_', '');
	
	//data = new Array();
	//data.push({name: 'message_id', value: message_id});
	
    $.ajaxJSON({
      method: 'post',
      url: ajax_get_lemma_from_note,
      data: {
        message_id: message_id
      },

    callback: function(result) {    
        
        if(result['new_notes_count']>0)
          $('#menu_option.notes a').text('Notatki ['+result['new_notes_count']+']');
        else
          $('#menu_option.notes a').text('Notatki');
        
        
		//window.lemma_from_note_id = result['lemma_id'];
		//window.lemma_from_note_entry = result['lemma_entry'];
    },
    error_callback: function(xhr, status, error) {
      error_alert(status + ': ' + error);
      //if (ctrl)
      //  ctrl.remove();
    },
  });
}
 
  $("tr.NotesTableRow").click(function(){
    selectNotesTr(this.id)});
    
  $("button#delete_user_note").click(function(){
    delete_user_note(window.selected_notes_row_id)});
    
  $("button#goto_lemma").click(function(){
    goto_lemma(window.selected_notes_row_id)});

// czysci pamiec sesji o wybranej notatce    
  $("#menu_option").click(function(){
    $.ajax({url: ajax_note_session_clear,
           async: false});
  });
    
});

function goto_lemma(id)
{
    if(id == -1)
	{
	  alert('Zaznacz notatkę aby przejść do powiązanego z nią hasła.');
	  return false;
	}
	
    lemma_view_location = window.location.toString();
    // trzeba by to moze z czasem poprawic na cos madrzejszego
    lemma_view_location = lemma_view_location.replace('/notatki/', '');
    window.location = lemma_view_location;
}
