# coding: utf8
from __future__ import unicode_literals

from spacy.util import load_model_from_init_py, get_model_meta
from pathlib import Path
from .preprocessor import PolishPreProcessor

__version__ = get_model_meta(Path(__file__).parent)['version']


def load(**overrides):
    model = load_model_from_init_py(__file__, **overrides)
    tokenizer = PolishPreProcessor(model)
    if tokenizer.imported_Morfeusz:
        model.tokenizer = tokenizer
    model.disable_pipes('tagger')
    # this is a temporary solution, the tagger is already utilized in the PreProcessor
    # so we need to load it, but it is not a pipeline component per se, so we disable it
    return model
