/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.actions;

import ipipan.spejd.actions.Action;
import ipipan.spejd.actions.AddAction;
import ipipan.spejd.actions.AgreeAction;
import ipipan.spejd.actions.DeleteAction;
import ipipan.spejd.actions.GroupAction;
import ipipan.spejd.actions.OrthCond;
import ipipan.spejd.actions.WordAction;
import ipipan.spejd.actions.WordActionArg;
import ipipan.spejd.actions.WordBasePart;
import ipipan.spejd.ruleparser.MatchParser;
import ipipan.spejd.util.Config;
import java.io.BufferedReader;
import java.util.ArrayList;

public class ActionParser
extends MatchParser {
    static final int AGREE = 0;
    static final int UNIFY = 1;
    static final int DELETE = 2;
    static final int LEAVE = 3;
    static final int ADD = 4;
    static final int SET = 5;
    static final int WORD = 6;
    static final int GROUP = 7;
    static final int ORTHC = 8;
    final String[] actions = new String[]{"agree", "unify", "delete", "leave", "add", "set", "word", "group", "orthnot"};

    public ActionParser(BufferedReader in, Config conf) {
        super(in, conf);
    }

    int readTokSpecDot() {
        int res = this.readNumber(false);
        this.forceEat(".", false);
        return res;
    }

    int[] intToInt(ArrayList<Integer> list) {
        int[] res = new int[list.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = list.get(i);
            ++i;
        }
        return res;
    }

    int[] readTokList() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        res.add(this.readNumber(true) - 1);
        while (this.currentCharIs(',')) {
            this.forceEat(",", true);
            res.add(this.readNumber(true) - 1);
        }
        return this.intToInt(res);
    }

    int[] readAttrList() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        while (this.currentCharNot(',')) {
            res.add(this.readAttrId());
        }
        return this.intToInt(res);
    }

    AgreeAction readAgreeAction(boolean unify) {
        int[] attr = this.readAttrList();
        this.forceEat(",", true);
        int[] segs = this.readTokList();
        return new AgreeAction(unify, attr, segs, this.conf);
    }

    DeleteAction readDeleteAction(boolean leave) {
        String regexp = this.readTokenRequirement().toLexRegexp();
        this.forceEat(",", true);
        int[] tok = this.readTokList();
        return new DeleteAction(leave, regexp, tok, this.conf);
    }

    AddAction readAddAction(boolean deleteOld) {
        String base;
        String tag = this.readTag();
        this.forceEat(",", true);
        if (this.currentCharIs('\"')) {
            base = this.readRegexp();
        } else {
            base = "";
            this.eat("base", true);
        }
        this.forceEat(",", true);
        int[] tok = this.readTokList();
        return new AddAction(deleteOld, tag, base, tok, this.conf);
    }

    WordActionArg readWordArg() {
        int tok = -1;
        if (this.currentCharIsDigit()) {
            tok = this.readNumber(true);
            this.forceEat(",", true);
        }
        ArrayList<WordBasePart> base = new ArrayList<WordBasePart>();
        String tag = this.readTag();
        this.eatWhite();
        this.forceEat(",", true);
        while (this.currentCharNotIn(";)")) {
            if (this.currentCharIsDigit()) {
                base.add(new WordBasePart(this.readTokSpecDot(), this.readAttrId()));
            } else if (tok > 0 && this.eat("base", true)) {
                base.add(new WordBasePart());
            } else {
                base.add(new WordBasePart(this.readRegexp()));
            }
            this.eatWhite();
        }
        if (tok > 0 && base.size() == 0) {
            base.add(new WordBasePart());
        }
        return new WordActionArg(tok, tag, base.toArray(new WordBasePart[0]), this.conf);
    }

    WordAction readWordAction() {
        ArrayList<WordActionArg> res = new ArrayList<WordActionArg>();
        while (this.currentCharNot(')')) {
            res.add(this.readWordArg());
            if (this.currentCharNotIn(";)")) {
                this.error("; or ) expected.");
            }
            this.eat(";", true);
        }
        return new WordAction(res.toArray(new WordActionArg[0]), this.conf);
    }

    GroupAction readGroupAction() {
        String type = this.readString();
        this.forceEat(",", true);
        int synh = this.readNumber(true);
        this.forceEat(",", true);
        int semh = this.readNumber(true);
        return new GroupAction(type, synh, semh, this.conf);
    }

    OrthCond readOrthCond() {
        String regexp = this.readRegexp();
        this.forceEat(",", true);
        int tok = this.readNumber(true);
        return new OrthCond(tok, regexp, this.conf);
    }

    int readActionType() {
        String action = this.readId();
        int i = 0;
        while (i < this.actions.length) {
            if (action.equals(this.actions[i])) {
                return i;
            }
            ++i;
        }
        this.error("Unknown action to evaluate.");
        return -1;
    }

    Action readActionContent(int type) {
        switch (type) {
            case 0: {
                return this.readAgreeAction(false);
            }
            case 1: {
                return this.readAgreeAction(true);
            }
            case 2: {
                return this.readDeleteAction(false);
            }
            case 3: {
                return this.readDeleteAction(true);
            }
            case 4: {
                return this.readAddAction(false);
            }
            case 5: {
                return this.readAddAction(true);
            }
            case 6: {
                return this.readWordAction();
            }
            case 7: {
                return this.readGroupAction();
            }
            case 8: {
                return this.readOrthCond();
            }
        }
        return null;
    }

    Action readAction() {
        int type = this.readActionType();
        this.forceEat("(", true);
        Action res = this.readActionContent(type);
        this.forceEat(")", true);
        this.forceEat(";", true);
        if (res == null) {
            this.error("Could not parse action.");
        }
        return res;
    }

    public Action[] readActionList(String start) {
        this.forceEat(start, true);
        ArrayList<Action> res = new ArrayList<Action>();
        while (this.charsLeft() && !this.preview("Rule") && !this.preview("Entry") && !this.preview("Gazetteer")) {
            res.add(this.readAction());
        }
        return res.toArray(new Action[0]);
    }
}

