/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.entities;

import ipipan.spejd.entities.Interpretation;
import ipipan.spejd.entities.Segment;
import ipipan.spejd.rules.AbstractRule;
import ipipan.spejd.util.Config;
import ipipan.spejd.util.Util;
import java.io.PrintStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public abstract class Entity {
    public static final char NULL = '0';
    public static final char TOKEN = 't';
    public static final char SEGMENT = 's';
    public static final char NOSPACE = 'n';
    public static final char WORD = 'w';
    public static final char GROUP = 'g';
    public static final Entity[] ARRAY = new Entity[0];
    public char type;
    String id;
    String text;
    boolean modified;
    boolean hide = false;
    Entity replacement;
    AbstractRule rule = null;
    Config conf = null;

    Entity(Config conf) {
        this.conf = conf;
    }

    public String concatAttr(int id, Entity[] s, int start, int end) {
        StringBuilder res = new StringBuilder();
        boolean nospace = true;
        int i = start;
        while (i < end) {
            if (s[i].type == 'n') {
                nospace = true;
            } else {
                if (!nospace) {
                    res.append(' ');
                }
                res.append(s[i].getAttr(id));
                nospace = false;
            }
            ++i;
        }
        return res.toString();
    }

    public String concatAttr(int id, Entity[] s) {
        return this.concatAttr(id, s, 0, s.length);
    }

    public Set<String> getCommonValues(Entity[] match, int[] attrIds) {
        Set<String> values = match[0].getAttrValues(attrIds, this.conf.nullAgreement);
        int i = 1;
        while (i < match.length) {
            values.retainAll(match[i].getAttrValues(attrIds, this.conf.nullAgreement));
            ++i;
        }
        return values;
    }

    public boolean unify(Entity[] match, int[] attrIds) {
        Set<String> values = this.getCommonValues(match, attrIds);
        if (values.size() == 0) {
            return false;
        }
        Util ut = new Util(this.conf);
        Pattern pattern = Pattern.compile(String.valueOf(ut.join("[^<>]+|", values)) + "[^<>]+");
        int i = 0;
        while (i < match.length) {
            match[i].delete(pattern, true);
            ++i;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public String getAttr(int id) {
        return "";
    }

    public Segment getSemHead() {
        return null;
    }

    public Segment getSynHead() {
        return null;
    }

    public String getGroupType() {
        return null;
    }

    public Set<Interpretation> getInterpretations() {
        return null;
    }

    public Interpretation[] getInterpretationArray() {
        return null;
    }

    public void delete(Pattern pattern, boolean neg) {
    }

    public void add(boolean delOld, String[] data) {
    }

    public Set<String> getAttrValues(int[] attrIds, boolean acceptNull) {
        return new TreeSet<String>();
    }

    public void setReplacement(Entity e) {
        this.hide = true;
        this.replacement = e;
    }

    public void setRule(AbstractRule rule) {
        this.rule = rule;
    }

    public Entity getReplacement() {
        if (!this.hide) {
            return this;
        }
        return this.replacement;
    }

    abstract void updateTxt();

    public String toTxt() {
        if (this.modified) {
            this.updateTxt();
        }
        return this.text;
    }

    public abstract void printXML(PrintStream var1);
}

