/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.readers;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.entities.Interpretation;
import ipipan.spejd.entities.NoSpace;
import ipipan.spejd.entities.Segment;
import ipipan.spejd.readers.Reader;
import ipipan.spejd.util.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;

public class MorphReader
extends Reader {
    BufferedReader in;
    int lineno;
    String line;
    ArrayList<Interpretation> ibuf;

    public MorphReader(File path, Config conf) {
        this.conf = conf;
        try {
            InputStream s = new FileInputStream(path);
            if (path.getName().endsWith(".gz")) {
                s = new GZIPInputStream(s);
            }
            this.in = new BufferedReader(new InputStreamReader(s, conf.inputEncoding));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lineno = 0;
        this.ibuf = new ArrayList();
        this.nextLine();
    }

    void nextLine() {
        String s = "";
        try {
            while (s != null && s.length() == 0) {
                ++this.lineno;
                s = this.in.readLine();
            }
            this.line = s;
        }
        catch (IOException e) {
            this.line = null;
        }
    }

    void error(String desc) {
        System.err.println("Error: " + desc);
        System.err.println("At line " + this.lineno);
        System.err.println(this.line);
        System.exit(1);
    }

    String getOrth() {
        if (!this.line.startsWith("<orth>")) {
            this.error("<orth> expected");
            return null;
        }
        return this.line.substring(6, this.line.indexOf("</orth>"));
    }

    Interpretation getInterp() {
        int i = 0;
        int j = 0;
        if (!this.line.startsWith("<lex")) {
            this.error("<lex> expected");
            return null;
        }
        i = this.line.indexOf("<base>") + 6;
        j = this.line.indexOf("</base>", i);
        String base = this.line.substring(i, j);
        i = this.line.indexOf("<ctag>", j) + 6;
        j = this.line.indexOf("</ctag>", i);
        String ctag = this.line.substring(i, j);
        return new Interpretation(String.valueOf(this.conf.tagset.cToFtag(ctag)) + base, this.line.indexOf("disamb=\"1\"") != -1, this.conf);
    }

    String getId() {
        if (!this.line.startsWith("<tok")) {
            this.error("<tok> expected");
            return null;
        }
        int i = this.line.indexOf("id=\"");
        if (i == -1) {
            return null;
        }
        return this.line.substring(i += 4, this.line.indexOf(34, i));
    }

    @Override
    public Entity loadToken() {
        this.ibuf.clear();
        if (this.line.equals("</chunk>")) {
            this.nextLine();
            return null;
        }
        if (this.line.equals("<ns/>")) {
            this.nextLine();
            return new NoSpace(this.conf);
        }
        String id = this.getId();
        this.nextLine();
        String orth = this.getOrth();
        this.nextLine();
        while (!this.line.equals("</tok>")) {
            this.ibuf.add(this.getInterp());
            this.nextLine();
        }
        this.nextLine();
        return new Segment(id, orth, this.ibuf.toArray(new Interpretation[0]), this.conf);
    }

    @Override
    public boolean nextSentence(PrintStream out) {
        while (true) {
            if (this.line == null) {
                return false;
            }
            if (this.line.equals("<chunk type=\"s\">")) break;
            out.println(this.line);
            this.nextLine();
        }
        this.nextLine();
        return true;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

