/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.readers;

import ipipan.spejd.readers.MorphReader;
import ipipan.spejd.readers.PlainTextReader;
import ipipan.spejd.readers.Reader;
import ipipan.spejd.readers.WorkbenchReader;
import ipipan.spejd.util.Config;
import java.io.File;
import java.nio.charset.Charset;
import morfologik.stemmers.Stempelator;

public class ReaderFactory {
    public static final int UNKNOWN = -1;
    public static final int AUTO = 0;
    public static final int PLAIN_TXT = 1;
    public static final int XCES_ANA = 2;
    public static final int CWB_OUT = 3;
    private Config conf;

    public ReaderFactory(Config conf) {
        this.conf = conf;
    }

    int getReaderType(String type) {
        if (type.equals("auto")) {
            return 0;
        }
        if (type.equals("txt")) {
            return 1;
        }
        if (type.equals("xcesAna")) {
            return 2;
        }
        if (type.equals("cwb")) {
            return 3;
        }
        System.out.println("Unknown inputType [" + type + "], please correct configuration.");
        return -1;
    }

    int getFileType(File path) {
        String f = path.getName();
        if (f.endsWith(".xml")) {
            return 2;
        }
        if (f.endsWith(".txt")) {
            return 1;
        }
        if (f.endsWith(".out")) {
            return 3;
        }
        System.out.println("Unknown type of file: " + f);
        return -1;
    }

    public Reader getReader(File path, Config conf, Stempelator stemmer) {
        int readerType = this.getReaderType(conf.inputType);
        int type = readerType == 0 ? this.getFileType(path) : readerType;
        switch (type) {
            case 1: {
                PlainTextReader plainTextReader = new PlainTextReader(conf, stemmer);
                plainTextReader.readTextFile(path.getPath(), Charset.forName(conf.inputEncoding));
                return plainTextReader;
            }
            case 2: {
                return new MorphReader(path, conf);
            }
            case 3: {
                return new WorkbenchReader(path, conf);
            }
        }
        return null;
    }
}

