/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.readers;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.entities.Interpretation;
import ipipan.spejd.entities.Segment;
import ipipan.spejd.readers.Reader;
import ipipan.spejd.util.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.zip.GZIPInputStream;

public class WorkbenchReader
extends Reader {
    BufferedReader in;
    int lineno;
    String line;
    Interpretation[] ibuf;

    public WorkbenchReader(File path, Config conf) {
        this.conf = conf;
        try {
            InputStream s = new FileInputStream(path);
            if (path.getName().endsWith(".gz")) {
                s = new GZIPInputStream(s);
            }
            this.in = new BufferedReader(new InputStreamReader(s, conf.inputEncoding));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lineno = 0;
        this.nextLine();
    }

    void nextLine() {
        String s = "";
        try {
            while (s != null && s.length() == 0) {
                ++this.lineno;
                s = this.in.readLine();
            }
            this.line = s;
        }
        catch (IOException e) {
            this.line = null;
        }
    }

    void error(String desc) {
        System.err.println("Error: " + desc);
        System.err.println("At line " + this.lineno);
        System.err.println(this.line);
        System.exit(1);
    }

    @Override
    public Entity loadToken() {
        if (this.line.startsWith("<")) {
            do {
                this.nextLine();
            } while (this.line != null && this.line.startsWith("<"));
            return null;
        }
        String[] tabs = this.line.split("\t");
        if (tabs.length < 2 || tabs.length > 3) {
            this.error("invalid number of columns - " + tabs.length);
        }
        this.nextLine();
        String orth = tabs[0];
        String ctag = tabs[1];
        String base = tabs.length == 3 ? tabs[2] : orth;
        this.ibuf = new Interpretation[1];
        this.ibuf[0] = new Interpretation(String.valueOf(this.conf.tagset.cToFtag(ctag)) + base, true, this.conf);
        return new Segment(null, orth, this.ibuf, this.conf);
    }

    @Override
    public boolean nextSentence(PrintStream out) {
        while (this.line != null) {
            if (!this.line.startsWith("<")) {
                return true;
            }
            out.println(this.line);
            this.nextLine();
        }
        return false;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

