/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.ruleparser;

import ipipan.spejd.ruleparser.EntityRequirement;
import ipipan.spejd.ruleparser.TokenRequirement;
import ipipan.spejd.util.Config;

public class GroupRequirement
extends EntityRequirement {
    public static final int SYNH = 1;
    public static final int SEMH = 2;
    public static final int BOTH = 3;
    public static final int TYPE = 4;
    static final String anyHead = "<[^>]+>";
    TokenRequirement synh = null;
    TokenRequirement semh = null;
    String type = "[^<>]+";
    boolean singleHead = false;

    public GroupRequirement(Config conf) {
        super(conf);
    }

    public void setHead(int flags, TokenRequirement head) {
        if ((flags & 1) > 0) {
            this.synh = head;
        }
        if ((flags & 2) > 0) {
            this.semh = head;
        }
        if (flags == 3) {
            this.singleHead = true;
        }
    }

    public void setType(String type) {
        this.type = this.safeRegexp(type);
    }

    @Override
    public String toRegexp() {
        StringBuilder res = new StringBuilder("(?><<g<");
        res.append("[^<>]+");
        res.append('<');
        res.append(this.singleHead ? (char)'1' : '.');
        res.append('<');
        res.append(this.safeRegexp(this.type));
        res.append('>');
        res.append(this.synh != null ? this.synh.toHeadRegexp() : anyHead);
        res.append(this.semh != null ? this.semh.toHeadRegexp() : anyHead);
        res.append(")");
        return res.toString();
    }
}

