/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.ruleparser;

import ipipan.spejd.ruleparser.EntityRequirement;
import ipipan.spejd.ruleparser.Requirement;
import ipipan.spejd.util.Config;

public class TokenRequirement
extends EntityRequirement {
    Requirement[][] reqs;
    int parenth;
    boolean hasForall = false;
    boolean hasExists = false;
    private static final int FORALL = 0;
    private static final int EXISTS = 1;

    public TokenRequirement(Config conf) {
        super(conf);
        this.reqs = new Requirement[2][conf.tagset.nOfAttributes()];
        int i = 0;
        while (i < this.reqs.length) {
            this.reqs[0][i] = null;
            this.reqs[1][i] = null;
            ++i;
        }
    }

    public void add(Requirement r) {
        if (r.forall()) {
            if (this.reqs[0][r.attrId] == null) {
                this.reqs[0][r.attrId] = r;
            } else {
                this.reqs[0][r.attrId].conjunction(r);
            }
            if (this.reqs[1][r.attrId] == null) {
                this.reqs[1][r.attrId] = r;
            } else {
                this.reqs[1][r.attrId].conjunction(r);
            }
            if (r.attrId > 0) {
                this.hasForall = true;
            }
        } else {
            if (this.reqs[1][r.attrId] == null) {
                this.reqs[1][r.attrId] = r;
            } else {
                this.reqs[1][r.attrId].conjunction(r);
            }
            if (r.attrId > 0) {
                this.hasExists = true;
            }
        }
    }

    String wordToRegexp(int forall, int id) {
        if (this.reqs[forall][id] == null) {
            return "[^<>]+";
        }
        return this.reqs[forall][id].toRegexp();
    }

    String lex(int forall) {
        StringBuilder res = new StringBuilder();
        res.append('<');
        int i = 2;
        while (i < this.reqs[forall].length) {
            if (this.reqs[forall][i] == null) {
                res.append('.');
            } else {
                res.append(this.reqs[forall][i].toRegexp());
            }
            ++i;
        }
        res.append(this.wordToRegexp(forall, 1));
        return res.toString();
    }

    public String toHeadRegexp() {
        String forall = this.hasForall ? this.lex(0) : "<[^<>]+";
        String regex = this.hasExists ? "(?:" + forall + ")*(?:" + this.lex(1) + ")" + "(?:" + forall + ")*" : "(?:" + forall + ")+";
        if (!this.hasForall && !this.hasExists) {
            regex = "<[^>]+";
        }
        return String.valueOf(regex) + ">";
    }

    @Override
    public String toRegexp() {
        return "(?><<t<[^<>]+<" + this.wordToRegexp(1, 0) + this.toHeadRegexp() + ")";
    }

    public String toLexRegexp() {
        return this.lex(1).substring(1);
    }
}

