/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.rules;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.rules.Match;
import ipipan.spejd.rules.Sentence;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatchPattern
implements Match {
    Pattern pattern;
    int[] group;
    int matchStart;
    int matchEnd;
    Sentence map;
    Matcher matcher;
    ArrayList<Entity>[] match;

    int countParenth(StringBuilder regexp) {
        int res = 0;
        int i = 0;
        while ((i = regexp.indexOf("(", i)) >= 0) {
            if (!(i != 0 && regexp.charAt(i - 1) == '\\' || i != regexp.length() - 1 && regexp.charAt(i + 1) == '?')) {
                ++res;
            }
            ++i;
        }
        return res;
    }

    void addPart(StringBuilder re, String[] part, int pos, boolean[] required) {
        int i = 0;
        while (i < part.length) {
            if (required[pos + i]) {
                this.group[pos + i] = this.countParenth(re) + 1;
                re.append('(');
            } else {
                this.group[pos + i] = -1;
            }
            re.append(part[i]);
            if (required[pos + i]) {
                re.append(')');
            }
            ++i;
        }
    }

    public MatchPattern(String[] left, String[] match, String[] right, boolean[] required) {
        boolean pos = false;
        this.group = new int[required.length];
        pos = false;
        this.matchStart = left.length;
        this.matchEnd = this.matchStart + match.length;
        StringBuilder re = new StringBuilder();
        this.addPart(re, left, 0, required);
        this.addPart(re, match, this.matchStart, required);
        this.addPart(re, right, this.matchEnd, required);
        this.pattern = Pattern.compile(re.toString());
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.pattern.pattern());
        res.append("\nMatch: ");
        res.append(String.valueOf(this.matchStart));
        res.append(" - ");
        res.append(String.valueOf(this.matchEnd));
        res.append(" of ");
        res.append(String.valueOf(this.group.length));
        res.append("\nGroups: ");
        int i = 0;
        while (i < this.group.length) {
            if (i != 0) {
                res.append(',');
            }
            res.append(String.valueOf(this.group[i]));
            ++i;
        }
        return res.toString();
    }

    public void feed(Sentence sentence) {
        this.matcher = this.pattern.matcher(sentence.text);
        this.match = new ArrayList[this.group.length];
        this.map = sentence;
    }

    ArrayList<Entity> findIds(String matchPart) {
        ArrayList<Entity> res = new ArrayList<Entity>();
        int i = 0;
        while ((i = matchPart.indexOf("<<", i)) >= 0) {
            int j = matchPart.indexOf(60, i += 4);
            res.add(this.map.get(matchPart.substring(i, j)));
            i = j;
        }
        return res;
    }

    public boolean nextMatch() {
        if (!this.matcher.find()) {
            return false;
        }
        boolean j = false;
        int i = 0;
        while (i < this.group.length) {
            if (this.group[i] >= 0) {
                String tmp = this.matcher.group(this.group[i]);
                if (tmp == null) {
                    System.err.println("Entity " + i + " (pattern group " + this.group[i] + ") in " + this.pattern.pattern() + " not found.");
                    System.err.println("Whole match: " + this.matcher.group(0));
                }
                this.match[i] = this.findIds(tmp);
            }
            ++i;
        }
        return true;
    }

    public void printMatch() {
        int i = 0;
        while (i < this.group.length) {
            System.err.print(' ');
            if (this.group[i] < 0) {
                System.err.print("<_>");
            } else {
                System.err.print('<');
                int j = 0;
                while (j < this.match[i].size()) {
                    if (j > 0) {
                        System.err.print(' ');
                    }
                    System.err.print(this.match[i].get(j).getAttr(0));
                    ++j;
                }
                System.err.print('>');
            }
            ++i;
        }
        System.err.println();
    }

    @Override
    public Entity getSingle(int s) {
        if (this.match[s].size() != 1) {
            System.err.println("Entity " + s + " not single in: ");
            this.printMatch();
        }
        return this.match[s].get(0);
    }

    @Override
    public Entity[] getSpec(int s) {
        return this.match[s].toArray(new Entity[0]);
    }

    @Override
    public Entity[] get(int[] s) {
        if (s == null) {
            return this.getMatch();
        }
        ArrayList<Entity> res = new ArrayList<Entity>();
        int i = 0;
        while (i < s.length) {
            res.addAll(this.match[s[i]]);
            ++i;
        }
        return res.toArray(new Entity[0]);
    }

    @Override
    public Entity[] getMatch() {
        ArrayList<Entity> res = new ArrayList<Entity>();
        int i = this.matchStart;
        while (i < this.matchEnd) {
            res.addAll(this.match[i]);
            ++i;
        }
        return res.toArray(new Entity[0]);
    }
}

