/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.tagset;

import ipipan.spejd.tagset.Attribute;
import ipipan.spejd.tagset.InterpretationFactor;
import java.util.ArrayList;

public class InterpretationArray {
    boolean single = true;
    char[] base;
    ArrayList<InterpretationFactor> factors;

    public InterpretationArray(int nAttr) {
        this.base = new char[nAttr];
        int i = 0;
        while (i < this.base.length) {
            this.base[i] = 48;
            ++i;
        }
        this.factors = new ArrayList();
    }

    public void addValue(Attribute attr, String val) {
        if (this.base == null || attr == null) {
            System.err.println("Attribute: [" + attr + "] value: [" + val + "]");
        }
        this.base[attr.id - 2] = attr.matchingValue(val);
    }

    public void addValues(Attribute attr, String values) {
        this.base[attr.id - 2] = 42;
        this.factors.add(new InterpretationFactor(attr, values));
        this.single = false;
    }

    public String toInterpretation() {
        if (!this.single) {
            System.err.println("Attempt to make an Array a single Interpretation");
        }
        return new String(this.base);
    }

    char[] copyInterpretation(char[] ftag) {
        char[] res = new char[ftag.length];
        int i = 0;
        while (i < ftag.length) {
            res[i] = ftag[i];
            ++i;
        }
        return res;
    }

    char[][] multiplyInterpretations(char[][] ftag, InterpretationFactor f) {
        char[] val = f.val;
        char[][] res = new char[ftag.length * val.length][];
        int i = 0;
        while (i < ftag.length) {
            int j = 0;
            while (j < val.length) {
                res[i * val.length + j] = this.copyInterpretation(ftag[i]);
                res[i * val.length + j][f.attr.id - 2] = val[j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public String[] toArray() {
        Object res = new char[][]{this.copyInterpretation(this.base)};
        int i = 0;
        while (i < this.factors.size()) {
            res = this.multiplyInterpretations((char[][])res, this.factors.get(i));
            ++i;
        }
        String[] sres = new String[((char[][])res).length];
        i = 0;
        while (i < ((char[][])res).length) {
            sres[i] = new String(res[i]);
            ++i;
        }
        return sres;
    }
}

