/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.util;

import ipipan.spejd.tagset.Tagset;
import ipipan.spejd.util.ArrayDict;
import ipipan.spejd.util.ConfigDict;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class Config {
    public Tagset tagset;
    public String rulesFile;
    public String logDir;
    public String outputFile;
    public char matchStrategy;
    public boolean nullAgreement;
    public boolean discardDeleted;
    public int reportInterval;
    public String inputType;
    public String inputEncoding;
    public Pattern inputFiles;
    public String lexDictionaries;
    public String outputSuffix;
    public int maxThreads;
    public Set<String> acronymsAfter;
    public Set<String> acronymsBefore;
    public Map<String, String[]> ogonkifySubstitutions;
    public char ogonkifyStrategy;
    public int ogonkifyMinLength;
    public int ogonkifyMaxLength;

    public Config(String configFilename, String[] args) {
        ConfigDict config = new ConfigDict(configFilename);
        int start = 1;
        if (args.length >= 3 && !config.isAssignment(args[1]) && !config.isAssignment(args[2])) {
            config.put("tagset", args[0]);
            config.put("rules", args[1]);
            start = 3;
        }
        config.putAssignments(args, start, 0);
        this.logDir = config.getDir("logDir");
        this.tagset = new Tagset(config.get("tagset"));
        this.rulesFile = config.get("rules");
        this.inputType = config.get("inputType");
        this.inputEncoding = config.get("inputEncoding");
        this.inputFiles = Pattern.compile(config.get("inputFiles"));
        this.matchStrategy = config.getChar("matchStrategy", "*+?");
        this.nullAgreement = config.getBool("nullAgreement");
        this.discardDeleted = config.getBool("discardDeleted");
        this.reportInterval = config.getInt("reportInterval");
        this.lexDictionaries = config.get("lexDictionaries");
        this.ogonkifySubstitutions = new ArrayDict(config.get("ogonkifyFile")).getDict();
        this.ogonkifyStrategy = config.getChar("ogonkifyStrategy", "AMN");
        this.ogonkifyMinLength = config.getInt("ogonkifyMinLength");
        this.ogonkifyMaxLength = config.getInt("ogonkifyMaxLength");
        this.outputSuffix = config.get("outputSuffix");
        this.maxThreads = config.getInt("maxThreads");
        this.acronymsAfter = new HashSet<String>(Arrays.asList(config.getArray("acronymsAfter", "\\|")));
        this.acronymsBefore = new HashSet<String>(Arrays.asList(config.getArray("acronymsBefore", "\\|")));
    }
}

