/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.util;

import ipipan.spejd.util.SimpleDict;
import java.io.File;

public class ConfigDict
extends SimpleDict {
    public static final String configFilename = "config.ini";

    public ConfigDict(String filename) {
        super(filename);
        this.load(filename);
    }

    public boolean isAssignment(String assign) {
        if (assign.length() == 0) {
            return false;
        }
        return assign.indexOf(61) > 0;
    }

    public boolean putAssignment(String assign) {
        if (!this.isAssignment(assign)) {
            System.err.print("Not a proper assignment: ");
            System.err.println(assign);
            return false;
        }
        int i = assign.indexOf(61);
        System.out.println("ConfigDict putAssignment: assign=" + assign);
        this.put(assign.substring(0, i).trim(), assign.substring(i + 1).trim());
        return true;
    }

    public boolean putAssignments(String[] args, int start, int end) {
        boolean res = true;
        if (end <= 0) {
            end = args.length - end;
        }
        int i = start;
        while (i < end) {
            res = res && this.putAssignment(args[i]);
            ++i;
        }
        return res;
    }

    public String get(String var) {
        String s = (String)this.dict.get(var);
        if (s != null) {
            return s;
        }
        return this.notFound(var);
    }

    public int getInt(String var) {
        return Integer.parseInt(this.get(var));
    }

    public int getHex(String var) {
        return Integer.parseInt(this.get(var), 16);
    }

    public boolean getBool(String var) {
        String s = this.get(var);
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("yes")) {
            return true;
        }
        if (s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("1")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        if (s.equalsIgnoreCase("no")) {
            return false;
        }
        if (s.equalsIgnoreCase("off")) {
            return false;
        }
        if (s.equalsIgnoreCase("0")) {
            return false;
        }
        System.err.println("Config: variable " + var + " has no valid boolean value.");
        return false;
    }

    public String getDir(String var) {
        String s = this.get(var);
        if (!s.endsWith("/")) {
            s = String.valueOf(s) + "/";
        }
        new File(s).mkdir();
        return s;
    }

    public char getChar(String var, String allowed) {
        char c;
        String s = this.get(var);
        if (s.length() == 1 && allowed.indexOf(c = s.charAt(0)) >= 0) {
            return c;
        }
        System.err.println("Config: variable " + var + " should be a single character, one of the following: [" + allowed + "]");
        return ' ';
    }

    public String[] getArray(String var, String separator) {
        String s = this.get(var);
        if (s.length() == 0) {
            return new String[0];
        }
        return s.split(separator);
    }

    public String notFound(String var) {
        System.err.println("Config: variable " + var + " not found");
        return null;
    }
}

