/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.util;

import ipipan.spejd.util.Config;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Util {
    Config conf;

    public Util(Config conf) {
        this.conf = conf;
    }

    public int safeParseInt(String c) {
        try {
            return Integer.parseInt(c);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public ArrayList<String> fileAsList(String filename) {
        ArrayList<String> rv = new ArrayList<String>();
        try {
            String inputLine;
            BufferedReader d = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), this.conf.inputEncoding));
            while ((inputLine = d.readLine()) != null) {
                if (inputLine.length() <= 0 || inputLine.charAt(0) == '#') continue;
                rv.add(inputLine);
            }
            d.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return rv;
    }

    public String[] file(String filename) {
        return this.fileAsList(filename).toArray(new String[0]);
    }

    public String join(String c, Collection d) {
        StringBuilder res = new StringBuilder();
        boolean notFirst = false;
        Iterator i = d.iterator();
        while (i.hasNext()) {
            if (notFirst) {
                res.append(c);
            } else {
                notFirst = true;
            }
            res.append(i.next());
        }
        return res.toString();
    }
}

