/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import morfologik.fsa.core.FSAHelpers;
import morfologik.fsa.core.FSATraversalHelper;
import morfologik.fsa.core.FSAVer5Impl;

public abstract class FSA {
    public static final int FSA_FLEXIBLE = 1;
    public static final int FSA_STOPBIT = 2;
    public static final int FSA_NEXTBIT = 4;
    public static final int FSA_TAILS = 8;
    public static final int FSA_WEIGHTED = 16;
    public static final int FSA_LARGE_DICTIONARIES = 32;
    public static final byte VERSION_5 = 5;
    protected byte version;
    protected byte filler;
    protected byte gotoLength;
    private byte annotationSeparator;
    private String dictionaryEncoding;

    protected FSA(InputStream fsaStream, String dictionaryEncoding) throws IOException {
        if (fsaStream == null) {
            throw new IllegalArgumentException("The input stream must not be null.");
        }
        if (dictionaryEncoding == null) {
            throw new IllegalArgumentException("Dictionary encoding must not be null.");
        }
        this.dictionaryEncoding = dictionaryEncoding;
        byte[] fsa = this.readFully(fsaStream);
        FilterInputStream input = null;
        try {
            input = new DataInputStream(new ByteArrayInputStream(fsa));
            this.readHeader((DataInput)((Object)input), fsa.length);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getFlags() {
        return FSAHelpers.getFlags(this.version);
    }

    public final char getAnnotationSeparator() {
        try {
            String annotationChar = new String(new byte[]{this.annotationSeparator}, this.dictionaryEncoding);
            if (annotationChar.length() != 1) {
                throw new RuntimeException("Unexpected annotation character length (should be 1): " + annotationChar.length());
            }
            return annotationChar.charAt(0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public final char getFillerCharacter() {
        try {
            String fillerChar = new String(new byte[]{this.filler}, this.dictionaryEncoding);
            if (fillerChar.length() != 1) {
                throw new RuntimeException("Unexpected filler character length (should be 1): " + fillerChar.length());
            }
            return fillerChar.charAt(0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract int getNumberOfArcs();

    public abstract int getNumberOfNodes();

    public abstract Node getStartNode();

    public FSATraversalHelper getTraversalHelper() {
        return new FSATraversalHelper();
    }

    public static FSA getInstance(File fsaFile, String dictionaryEncoding) throws IOException {
        if (!fsaFile.exists()) {
            throw new IOException("File does not exist: " + fsaFile.getAbsolutePath());
        }
        return FSA.getInstance(new FileInputStream(fsaFile), dictionaryEncoding);
    }

    public static FSA getInstance(InputStream fsaStream, String dictionaryEncoding) throws IOException {
        if (fsaStream == null) {
            throw new IllegalArgumentException("FSA stream cannot be null.");
        }
        PushbackInputStream stream = new PushbackInputStream(fsaStream, 5);
        byte[] header = new byte[5];
        stream.read(header);
        if (header[0] == 92 && header[1] == 102 && header[2] == 115 && header[3] == 97) {
            byte version = header[4];
            stream.unread(header);
            switch (version) {
                case 5: {
                    return new FSAVer5Impl(stream, dictionaryEncoding);
                }
            }
            throw new IOException("Cannot read FSA: support for version " + version + " (" + FSAHelpers.flagsToString(FSAHelpers.getFlags(version)) + ") not implemented.");
        }
        throw new IOException("Cannot read FSA: file does not begin with a valid magic number.");
    }

    protected void readHeader(DataInput in, long fileSize) throws IOException {
        byte[] magic = new byte[4];
        in.readFully(magic);
        if (magic[0] != 92 || magic[1] != 102 || magic[2] != 115 || magic[3] != 97) {
            throw new IOException("Cannot read FSA: File does not begin with a valid magic number.");
        }
        this.version = in.readByte();
        this.filler = in.readByte();
        this.annotationSeparator = in.readByte();
        this.gotoLength = in.readByte();
    }

    protected byte[] readFully(InputStream stream) throws IOException {
        int bytesCount;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
        byte[] buffer = new byte[8192];
        while ((bytesCount = stream.read(buffer)) > 0) {
            baos.write(buffer, 0, bytesCount);
        }
        return baos.toByteArray();
    }

    public static interface Arc {
        public Node getDestinationNode();

        public byte getLabel();

        public boolean isFinal();

        public boolean isLast();

        public boolean isTerminal();
    }

    public static interface Node {
        public Arc getFirstArc();

        public Arc getNextArc(Arc var1);

        public Arc getArcLabelledWith(byte var1);
    }
}

