/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.dictionary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import morfologik.fsa.core.FSA;
import morfologik.fsa.dictionary.DictionaryFeatures;
import morfologik.util.FileUtils;
import morfologik.util.ResourceUtils;

public class Dictionary {
    private static final String FEATURES_SUFFIX = "info";
    public final FSA fsa;
    public final DictionaryFeatures features;

    public Dictionary(FSA fsa, DictionaryFeatures features) {
        this.fsa = fsa;
        this.features = features;
    }

    public static Dictionary read(File fsaFile) throws IOException {
        File featuresFile = new File(fsaFile.getParent(), Dictionary.getExpectedFeaturesName(fsaFile.getName()));
        FileUtils.assertExists(featuresFile, true, false);
        FileInputStream featuresData = new FileInputStream(featuresFile);
        FileInputStream fsaData = new FileInputStream(fsaFile);
        try {
            Dictionary dictionary = Dictionary.read(fsaData, featuresData);
            return dictionary;
        }
        finally {
            ((InputStream)featuresData).close();
            ((InputStream)fsaData).close();
        }
    }

    public static Dictionary read(URL fsaURL) throws IOException {
        InputStream fsaData;
        InputStream featuresData;
        String fsa = fsaURL.toExternalForm();
        String features = Dictionary.getExpectedFeaturesName(fsa);
        try {
            featuresData = ResourceUtils.openInputStream(features);
        }
        catch (IOException e) {
            throw new IOException("Could not read dictionary features file: " + e.getMessage());
        }
        try {
            fsaData = ResourceUtils.openInputStream(fsa);
        }
        catch (IOException e) {
            throw new IOException("Could not read FSA dictionary file: " + e.getMessage());
        }
        try {
            Dictionary dictionary = Dictionary.read(fsaData, featuresData);
            return dictionary;
        }
        finally {
            featuresData.close();
            fsaData.close();
        }
    }

    public static Dictionary read(InputStream fsaData, InputStream featuresData) throws IOException {
        Properties properties = new Properties();
        properties.load(featuresData);
        DictionaryFeatures features = DictionaryFeatures.fromMap(properties);
        FSA fsa = FSA.getInstance(fsaData, features.encoding);
        return new Dictionary(fsa, features);
    }

    public static String getExpectedFeaturesName(String name) {
        int dotIndex = name.lastIndexOf(46);
        String featuresName = dotIndex >= 0 ? String.valueOf(name.substring(0, dotIndex)) + "." + FEATURES_SUFFIX : String.valueOf(name) + "." + FEATURES_SUFFIX;
        return featuresName;
    }
}

