/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemmers;

import java.io.IOException;
import morfologik.stemmers.IStemmer;

public class CascadedStemmer
implements IStemmer {
    private final IStemmer[] stemmers;

    public CascadedStemmer(IStemmer[] stemmers) throws IOException {
        this.stemmers = stemmers;
    }

    @Override
    public String[] stem(String word) {
        int i = 0;
        while (i < this.stemmers.length) {
            String[] result = this.stemmers[i].stem(word);
            if (result != null && result.length > 0) {
                return result;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String[] stemAndForm(String word) {
        int i = 0;
        while (i < this.stemmers.length) {
            String[] result = this.stemmers[i].stemAndForm(word);
            if (result != null && result.length > 0) {
                return result;
            }
            ++i;
        }
        return null;
    }
}

