/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.util.logging.Level;
import java.util.logging.Logger;
import morfologik.tools.ConfigurationException;
import morfologik.util.StringUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public abstract class BaseCommandLineTool {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final Options cliOptions = new Options();

    protected final void go(String[] args) {
        this.initializeOptions(this.cliOptions);
        if (args.length == 0) {
            this.printUsage();
            return;
        }
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(this.cliOptions, args);
            try {
                this.go(line);
            }
            catch (ConfigurationException e) {
                this.logger.severe(StringUtils.chainExceptionMessages(e));
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Unhandled program error occurred.", e);
            }
        }
        catch (MissingArgumentException e) {
            this.logger.log(Level.SEVERE, "Provide the required argument for option " + e.getMessage());
            this.printUsage();
        }
        catch (MissingOptionException e) {
            this.logger.log(Level.SEVERE, "Provide the required option " + e.getMessage());
            this.printUsage();
        }
        catch (UnrecognizedOptionException e) {
            this.logger.log(Level.SEVERE, String.valueOf(e.getMessage()) + "\n");
            this.printUsage();
        }
        catch (ParseException exp) {
            this.logger.log(Level.SEVERE, "Could not parse command line: " + exp.getMessage());
            this.printUsage();
        }
    }

    protected void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getClass().getName(), this.cliOptions, true);
    }

    protected abstract void go(CommandLine var1) throws Exception;

    protected abstract void initializeOptions(Options var1);

    protected final Logger getLogger() {
        return this.logger;
    }
}

