/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Locale;
import morfologik.stemmers.IStemmer;
import morfologik.tools.BaseCommandLineTool;
import morfologik.tools.CommandLineOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

class TextStemmingTool
extends BaseCommandLineTool {
    private final IStemmer stemmer;

    public TextStemmingTool(IStemmer stemmer) {
        this.stemmer = stemmer;
    }

    @Override
    protected void go(CommandLine line) throws Exception {
        String inputEncoding = this.getEncodingOption(line, CommandLineOptions.inputEncodingOption.getOpt());
        String outputEncoding = this.getEncodingOption(line, CommandLineOptions.outputEncodingOption.getOpt());
        this.logger.info("Input encoding: " + inputEncoding);
        this.logger.info("Output encoding: " + outputEncoding);
        Reader input = this.initializeInput(line, inputEncoding);
        Writer output = this.initializeOutput(line, outputEncoding);
        long start = System.currentTimeMillis();
        try {
            long count = this.process(input, output);
            output.flush();
            long millis = System.currentTimeMillis() - start;
            double time = (double)millis / 1000.0;
            double wordsPerSec = time > 0.0 ? (double)count / time : Double.POSITIVE_INFINITY;
            this.logger.info(new MessageFormat("Processed {0} words in {1,number,#.###} seconds ({2,number,#} words per second).", Locale.ENGLISH).format(new Object[]{new Long(count), new Double((double)millis / 1000.0), new Double(wordsPerSec)}));
        }
        finally {
            input.close();
            output.close();
        }
    }

    protected long process(Reader input, Writer output) throws IOException {
        int token;
        StreamTokenizer st = new StreamTokenizer(input);
        st.eolIsSignificant(false);
        st.wordChars(43, 43);
        long count = 0L;
        while ((token = st.nextToken()) != -1) {
            if (token != -3) continue;
            String word = st.sval;
            ++count;
            String[] stems = this.stemmer.stemAndForm(word);
            if (stems == null || stems.length == 0) {
                output.write(word);
                output.write("\t-\t-\n");
                continue;
            }
            int i = 0;
            while (i < stems.length) {
                output.write(word);
                output.write("\t");
                output.write(stems[i] != null ? stems[i] : "-");
                output.write("\t");
                output.write(stems[i + 1] != null ? stems[i + 1] : "-");
                output.write("\n");
                i += 2;
            }
        }
        return count;
    }

    @Override
    protected void initializeOptions(Options options) {
        options.addOption(CommandLineOptions.inputFileOption);
        options.addOption(CommandLineOptions.inputEncodingOption);
        options.addOption(CommandLineOptions.outputFileOption);
        options.addOption(CommandLineOptions.outputEncodingOption);
    }

    private Writer initializeOutput(CommandLine line, String outputEncoding) throws IOException {
        String opt = CommandLineOptions.outputFileOption.getOpt();
        OutputStreamWriter output = line.hasOption(opt) ? new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream((File)line.getOptionObject(opt))), outputEncoding) : new OutputStreamWriter((OutputStream)System.out, outputEncoding);
        return output;
    }

    private Reader initializeInput(CommandLine line, String inputEncoding) throws IOException {
        String opt = CommandLineOptions.inputFileOption.getOpt();
        InputStreamReader input = line.hasOption(opt) ? new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream((File)line.getOptionObject(opt))), inputEncoding) : new InputStreamReader(System.in, inputEncoding);
        return input;
    }

    private String getEncodingOption(CommandLine line, String opt) {
        String encoding = System.getProperty("file.encoding", "iso-8859-1");
        if (line.hasOption(opt)) {
            encoding = line.getOptionValue(opt);
        }
        return encoding;
    }
}

