/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.egothor.stemmer.Reduce;
import org.egothor.stemmer.Trie;

public class MultiTrie
extends Trie {
    final String EOM = "*";
    Vector tries = new Vector();
    int BY = 1;

    public MultiTrie(DataInput dataInput) throws IOException {
        super(false);
        this.forward = dataInput.readBoolean();
        this.BY = dataInput.readInt();
        for (int i = dataInput.readInt(); i > 0; --i) {
            this.tries.addElement(new Trie(dataInput));
        }
    }

    public MultiTrie(boolean bl) {
        super(bl);
    }

    public String getFully(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.tries.size() * 2);
        for (int i = 0; i < this.tries.size(); ++i) {
            String string2 = ((Trie)this.tries.elementAt(i)).getFully(string);
            if ("*".equalsIgnoreCase(string2)) {
                return stringBuffer.toString();
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getLastOnPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.tries.size() * 2);
        for (int i = 0; i < this.tries.size(); ++i) {
            String string2 = ((Trie)this.tries.elementAt(i)).getLastOnPath(string);
            if ("*".equalsIgnoreCase(string2)) {
                return stringBuffer.toString();
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void store(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.forward);
        dataOutput.writeInt(this.BY);
        dataOutput.writeInt(this.tries.size());
        Enumeration enumeration = this.tries.elements();
        while (enumeration.hasMoreElements()) {
            ((Trie)enumeration.nextElement()).store(dataOutput);
        }
    }

    public void add(String string, String string2) {
        if (string2.length() == 0) {
            return;
        }
        int n = string2.length() / this.BY;
        while (n >= this.tries.size()) {
            this.tries.addElement(new Trie(this.forward));
        }
        for (int i = 0; i < n; ++i) {
            ((Trie)this.tries.elementAt(i)).add(string, string2.substring(this.BY * i, this.BY * i + this.BY));
        }
        ((Trie)this.tries.elementAt(n)).add(string, "*");
    }

    public Trie reduce(Reduce reduce) {
        Trie trie;
        Vector<Trie> vector = new Vector<Trie>();
        Enumeration enumeration = this.tries.elements();
        while (enumeration.hasMoreElements()) {
            trie = (Trie)enumeration.nextElement();
            vector.addElement(trie.reduce(reduce));
        }
        trie = new MultiTrie(this.forward);
        ((MultiTrie)trie).tries = vector;
        return trie;
    }

    public void printInfo(String string) {
        int n = 0;
        Enumeration enumeration = this.tries.elements();
        while (enumeration.hasMoreElements()) {
            Trie trie = (Trie)enumeration.nextElement();
            trie.printInfo(string + "[" + n + "] ");
            ++n;
        }
    }
}

