/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import org.egothor.stemmer.Diff;
import org.egothor.stemmer.Gener;
import org.egothor.stemmer.Lift;
import org.egothor.stemmer.MultiTrie2;
import org.egothor.stemmer.Optimizer;
import org.egothor.stemmer.Optimizer2;
import org.egothor.stemmer.Reduce;
import org.egothor.stemmer.Trie;

public class Test {
    static boolean backward;
    static boolean multi;
    static Trie trie;

    public static void selfTest() {
        int n;
        Trie trie = new Trie(true);
        String[] stringArray = new String[]{"a", "ba", "bb", "c"};
        String[] stringArray2 = new String[]{"1", "2", "2", "4"};
        for (n = 0; n < stringArray.length; ++n) {
            trie.add(stringArray[n], stringArray2[n]);
        }
        System.out.println("Trie root:" + trie.root + " size:" + trie.rows.size() + " keys:" + trie.cmds.size());
        trie = trie.reduce(new Optimizer());
        System.out.println("Trie root:" + trie.root + " size:" + trie.rows.size() + " keys:" + trie.cmds.size());
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println(stringArray[n] + " ---> " + trie.getFully(stringArray[n]));
        }
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println(stringArray[n] + " -l-> " + trie.getLastOnPath(stringArray[n]));
        }
        System.out.println("ac -l-> " + trie.getLastOnPath("ac"));
        System.out.println("abc -l-> " + trie.getLastOnPath("abc"));
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 1) {
            Test.selfTest();
            return;
        }
        stringArray[0].toUpperCase();
        backward = stringArray[0].charAt(0) == '-';
        int n2 = backward ? 1 : 0;
        boolean bl = false;
        if (stringArray[0].charAt(n2) == '0') {
            bl = true;
            ++n2;
        }
        boolean bl2 = multi = stringArray[0].charAt(n2) == 'M';
        if (multi) {
            ++n2;
        }
        char[] cArray = new char[stringArray[0].length() - n2];
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = stringArray[0].charAt(n2 + n);
        }
        for (n = 1; n < stringArray.length; ++n) {
            Diff diff = new Diff();
            try {
                int n3 = 0;
                int n4 = 0;
                LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(stringArray[n])));
                Object object = lineNumberReader.readLine();
                while (object != null) {
                    try {
                        object = ((String)object).toLowerCase();
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                        String string = stringTokenizer.nextToken();
                        if (bl) {
                            ++n4;
                        }
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            if (string2.equals(string)) continue;
                            ++n4;
                        }
                        ++n3;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    object = lineNumberReader.readLine();
                }
                System.out.println("# words stems");
                System.out.println("H: " + n4 + " " + n3);
                object = new double[]{1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.09, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03};
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object2;
                    Object object3;
                    Object object4;
                    int n5 = 0;
                    boolean bl3 = false;
                    int n6 = (int)((double)n4 * object[i]);
                    Random random = new Random();
                    Test.allocTrie();
                    lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(stringArray[n])));
                    String string = lineNumberReader.readLine();
                    while (string != null) {
                        try {
                            string = string.toLowerCase();
                            object4 = new StringTokenizer(string);
                            object3 = ((StringTokenizer)object4).nextToken();
                            if (bl && random.nextInt(n4) < n6) {
                                trie.add((String)object3, "-a");
                                ++n5;
                            }
                            while (((StringTokenizer)object4).hasMoreTokens()) {
                                object2 = ((StringTokenizer)object4).nextToken();
                                if (((String)object2).equals(object3) || random.nextInt(n4) >= n6) continue;
                                trie.add((String)object2, diff.exec((String)object2, (String)object3));
                                ++n5;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                        string = lineNumberReader.readLine();
                    }
                    string = Integer.toString(100 * (n4 - n5) / n4);
                    string = Integer.toString(100 - (int)(object[i] * 100.0));
                    trie.printInfo("T: " + string + " ");
                    object4 = new Optimizer();
                    object3 = new Optimizer2();
                    object2 = new Lift(true);
                    Lift lift = new Lift(false);
                    Gener gener = new Gener();
                    block21: for (int j = 0; j < cArray.length; ++j) {
                        String string3;
                        switch (cArray[j]) {
                            case 'G': {
                                trie = trie.reduce(gener);
                                string3 = "G: ";
                                break;
                            }
                            case 'L': {
                                trie = trie.reduce((Reduce)object2);
                                string3 = "L: ";
                                break;
                            }
                            case 'E': {
                                trie = trie.reduce(lift);
                                string3 = "E: ";
                                break;
                            }
                            case '2': {
                                trie = trie.reduce((Reduce)object3);
                                string3 = "2: ";
                                break;
                            }
                            case '1': {
                                trie = trie.reduce((Reduce)object4);
                                string3 = "1: ";
                                break;
                            }
                            default: {
                                continue block21;
                            }
                        }
                        trie.printInfo(string3 + string + " ");
                    }
                    System.out.print("Full: " + string + " ");
                    Test.testTrie(trie, stringArray[n], true, bl);
                    System.out.print("Last: " + string + " ");
                    Test.testTrie(trie, stringArray[n], false, bl);
                }
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static void allocTrie() {
        trie = multi ? new MultiTrie2(!backward) : new Trie(!backward);
    }

    static void testTrie(Trie trie, String string, boolean bl, boolean bl2) {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(string)));
            int n = 0;
            int n2 = 0;
            Diff diff = new Diff();
            String string2 = lineNumberReader.readLine();
            while (string2 != null) {
                try {
                    String string3;
                    String string4;
                    string2 = string2.toLowerCase();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    String string5 = stringTokenizer.nextToken();
                    if (bl2) {
                        ++n;
                        string4 = bl ? trie.getFully(string5) : trie.getLastOnPath(string5);
                        string3 = Diff.apply(new StringBuffer(string5), string4).toString();
                        if (!string3.equalsIgnoreCase(string5)) {
                            System.err.println(string5 + " != " + string5 + "@" + string4 + "=" + string3);
                        } else {
                            ++n2;
                        }
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                        if (string4.equals(string5)) continue;
                        ++n;
                        string3 = bl ? trie.getFully(string4) : trie.getLastOnPath(string4);
                        String string6 = Diff.apply(new StringBuffer(string4), string3).toString();
                        if (!string6.equalsIgnoreCase(string5)) {
                            System.err.println(string5 + " != " + string4 + "@" + string3 + "=" + string6);
                            continue;
                        }
                        ++n2;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                string2 = lineNumberReader.readLine();
            }
            System.out.println("tests " + n + " succ " + n2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

