/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.egothor.stemmer.Diff;
import org.egothor.stemmer.MultiTrie2;
import org.egothor.stemmer.Trie;

public class TestLoad {
    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Use 2 params or more.");
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(stringArray[0])));
            String string = dataInputStream.readUTF().toUpperCase();
            Trie trie = string.indexOf(77) < 0 ? new Trie(dataInputStream) : new MultiTrie2(dataInputStream);
            dataInputStream.close();
            TestLoad.testTrie(trie, stringArray[1], false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    static void testTrie(Trie trie, String string, boolean bl) {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8")));
            int n = 0;
            int n2 = 0;
            long l = 0L;
            long l2 = 0L;
            Diff diff = new Diff();
            String string2 = lineNumberReader.readLine();
            while (string2 != null) {
                try {
                    string2 = string2.toLowerCase();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    String string3 = stringTokenizer.nextToken();
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        ++n;
                        l2 = System.currentTimeMillis();
                        String string5 = bl ? trie.getFully(string4) : trie.getLastOnPath(string4);
                        String string6 = Diff.apply(new StringBuffer(string4), string5).toString();
                        l2 = System.currentTimeMillis() - l2;
                        l += l2;
                        if (!string6.equalsIgnoreCase(string3)) {
                            System.err.println(string3 + " != " + string4 + "@" + string5 + "=" + string6);
                            continue;
                        }
                        ++n2;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                string2 = lineNumberReader.readLine();
            }
            System.out.println("tests " + n + " succ " + n2 + " err " + (float)(n - n2) * 100.0f / (float)n + "% avg. time " + (double)l / (double)n);
            trie.printInfo("Trie Info: ");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

