/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.egothor.stemmer.Cell;
import org.egothor.stemmer.Reduce;
import org.egothor.stemmer.Row;

public class Trie {
    Vector rows = new Vector();
    Vector cmds = new Vector();
    int root;
    boolean forward = false;

    public Trie(DataInput dataInput) throws IOException {
        int n;
        this.forward = dataInput.readBoolean();
        this.root = dataInput.readInt();
        for (n = dataInput.readInt(); n > 0; --n) {
            this.cmds.addElement(dataInput.readUTF());
        }
        for (n = dataInput.readInt(); n > 0; --n) {
            this.rows.addElement(new Row(dataInput));
        }
    }

    public Trie(boolean bl) {
        this.rows.addElement(new Row());
        this.root = 0;
        this.forward = bl;
    }

    public Trie(boolean bl, int n, Vector vector, Vector vector2) {
        this.rows = vector2;
        this.cmds = vector;
        this.root = n;
        this.forward = bl;
    }

    public String[] getAll(String string) {
        int n;
        int n2;
        int[] nArray = new int[string.length()];
        int n3 = 0;
        Row row = this.getRow(this.root);
        StrEnum strEnum = new StrEnum(string, this.forward);
        boolean bl = false;
        for (n2 = 0; n2 < string.length() - 1; ++n2) {
            Character c = new Character(strEnum.next());
            n = row.getCmd(c);
            if (n >= 0) {
                int n4 = n;
                for (int i = 0; i < n3; ++i) {
                    if (n4 != nArray[i]) continue;
                    n4 = -1;
                    break;
                }
                if (n4 >= 0) {
                    nArray[n3++] = n4;
                }
            }
            if ((n = row.getRef(c)) < 0) {
                bl = true;
                break;
            }
            row = this.getRow(n);
        }
        if (!bl && (n = row.getCmd(new Character(strEnum.next()))) >= 0) {
            n2 = n;
            for (int i = 0; i < n3; ++i) {
                if (n2 != nArray[i]) continue;
                n2 = -1;
                break;
            }
            if (n2 >= 0) {
                nArray[n3++] = n2;
            }
        }
        if (n3 < 1) {
            return null;
        }
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = (String)this.cmds.elementAt(nArray[i]);
        }
        return stringArray;
    }

    public int getCells() {
        int n = 0;
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Row)enumeration.nextElement()).getCells();
        }
        return n;
    }

    public int getCellsPnt() {
        int n = 0;
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Row)enumeration.nextElement()).getCellsPnt();
        }
        return n;
    }

    public int getCellsVal() {
        int n = 0;
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Row)enumeration.nextElement()).getCellsVal();
        }
        return n;
    }

    public String getFully(String string) {
        Row row = this.getRow(this.root);
        int n = -1;
        StrEnum strEnum = new StrEnum(string, this.forward);
        Character c = null;
        Character c2 = null;
        int n2 = 0;
        while (n2 < string.length()) {
            c = new Character(strEnum.next());
            ++n2;
            Cell cell = row.at(c);
            if (cell == null) {
                return null;
            }
            n = cell.cmd;
            for (int i = cell.skip; i > 0; --i) {
                if (n2 >= string.length()) {
                    return null;
                }
                c2 = new Character(strEnum.next());
                ++n2;
            }
            int n3 = row.getRef(c);
            if (n3 >= 0) {
                row = this.getRow(n3);
                continue;
            }
            if (n2 >= string.length()) continue;
            return null;
        }
        return n == -1 ? null : (String)this.cmds.elementAt(n);
    }

    public String getLastOnPath(String string) {
        int n;
        Row row = this.getRow(this.root);
        String string2 = null;
        StrEnum strEnum = new StrEnum(string, this.forward);
        for (int i = 0; i < string.length() - 1; ++i) {
            Character c = new Character(strEnum.next());
            n = row.getCmd(c);
            if (n >= 0) {
                string2 = (String)this.cmds.elementAt(n);
            }
            if ((n = row.getRef(c)) < 0) {
                return string2;
            }
            row = this.getRow(n);
        }
        n = row.getCmd(new Character(strEnum.next()));
        return n >= 0 ? (String)this.cmds.elementAt(n) : string2;
    }

    private Row getRow(int n) {
        if (n < 0 || n >= this.rows.size()) {
            return null;
        }
        return (Row)this.rows.elementAt(n);
    }

    public void store(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.forward);
        dataOutput.writeInt(this.root);
        Enumeration enumeration = this.cmds.elements();
        dataOutput.writeInt(this.cmds.size());
        while (enumeration.hasMoreElements()) {
            dataOutput.writeUTF((String)enumeration.nextElement());
        }
        enumeration = this.rows.elements();
        dataOutput.writeInt(this.rows.size());
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            row.store(dataOutput);
        }
    }

    public void add(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if (string2.length() == 0) {
            return;
        }
        int n = this.cmds.indexOf(string2);
        if (n == -1) {
            n = this.cmds.size();
            this.cmds.addElement(string2);
        }
        int n2 = this.root;
        Row row = this.getRow(n2);
        StrEnum strEnum = new StrEnum(string, this.forward);
        for (int i = 0; i < strEnum.length() - 1; ++i) {
            Character c = new Character(strEnum.next());
            n2 = row.getRef(c);
            if (n2 >= 0) {
                row = this.getRow(n2);
                continue;
            }
            n2 = this.rows.size();
            Row row2 = new Row();
            this.rows.addElement(row2);
            row.setRef(c, n2);
            row = row2;
        }
        row.setCmd(new Character(strEnum.next()), n);
    }

    public Trie reduce(Reduce reduce) {
        return reduce.optimize(this);
    }

    public void printInfo(String string) {
        System.out.println(string + "nds " + this.rows.size() + " cmds " + this.cmds.size() + " cells " + this.getCells() + " valcells " + this.getCellsVal() + " pntcells " + this.getCellsPnt());
    }

    class StrEnum {
        String s;
        int from;
        int by;

        StrEnum(String string, boolean bl) {
            this.s = string;
            if (bl) {
                this.from = 0;
                this.by = 1;
            } else {
                this.from = string.length() - 1;
                this.by = -1;
            }
        }

        int length() {
            return this.s.length();
        }

        char next() {
            char c = this.s.charAt(this.from);
            this.from += this.by;
            return c;
        }
    }
}

