/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.stempel;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import org.getopt.stempel.Stemmer;

public class Benchmark {
    public static final int COUNT = 3;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Stemmer stemmer = stringArray.length > 1 ? new Stemmer(stringArray[1]) : new Stemmer();
        stemmer.MIN_LENGTH = 0;
        long[] lArray = new long[3];
        long[] lArray2 = new long[3];
        long[] lArray3 = new long[3];
        for (int i = 0; i < 3; ++i) {
            lArray[i] = 0L;
            lArray2[i] = 0L;
            lArray3[i] = 0L;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stringArray[0]), "UTF-8"));
            while ((object3 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object3);
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken().toLowerCase();
                    long l = System.currentTimeMillis();
                    object = stemmer.stem((String)object2, false);
                    l = System.currentTimeMillis() - l;
                    int n = i;
                    lArray3[n] = lArray3[n] + l;
                    int n2 = i;
                    lArray[n2] = lArray[n2] + 1L;
                    if (object != null) continue;
                    int n3 = i;
                    lArray2[n3] = lArray2[n3] + 1L;
                }
            }
            bufferedReader.close();
        }
        System.out.println("--------- Stemmer benchmark report: -----------");
        System.out.println("Stemmer table:  " + stemmer.getTableResPath());
        System.out.println("Input file:     " + stringArray[0]);
        System.out.println("Number of runs: 3");
        System.out.print("\n RUN NUMBER:\t");
        double[] dArray = new double[3];
        object3 = new double[3];
        object = new double[3];
        object2 = new double[3];
        for (int i = 0; i < 3; ++i) {
            System.out.print("\t" + (i + 1));
            dArray[i] = (double)(lArray[i] - lArray2[i]) / (double)lArray[i];
            object3[i] = (double)lArray2[i] / (double)lArray[i];
            object[i] = (double)lArray[i] / (double)lArray3[i] * 1000.0;
            object2[i] = (double)lArray3[i] * 1000.0 / (double)lArray[i];
        }
        System.out.println();
        Benchmark.printLongArray("Total input words", lArray);
        Benchmark.printLongArray("Missed output words", lArray2);
        Benchmark.printLongArray("Time elapsed [ms]", lArray3);
        Benchmark.printDoubleArray("Hit rate percent", dArray, "#00.00%");
        Benchmark.printDoubleArray("Miss rate percent", (double[])object3, "#00.00%");
        Benchmark.printDoubleArray("Words per second", object, "00000");
        Benchmark.printDoubleArray("Time per word [us]", (double[])object2, "#0.00");
    }

    public static void printLongArray(String string, long[] lArray) {
        System.out.print(" " + string);
        for (int i = 0; i < lArray.length; ++i) {
            System.out.print("\t" + lArray[i]);
        }
        System.out.println();
    }

    public static void printDoubleArray(String string, double[] dArray, String string2) {
        DecimalFormat decimalFormat = new DecimalFormat(string2);
        System.out.print(" " + string);
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print("\t" + decimalFormat.format(dArray[i]));
        }
        System.out.println();
    }
}

