/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.stempel;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.egothor.stemmer.Diff;
import org.egothor.stemmer.MultiTrie2;
import org.egothor.stemmer.Trie;

public class Stemmer {
    public int MIN_LENGTH = 3;
    Trie stemmer = null;
    String tableResPath = null;

    public Stemmer() {
        this(System.getProperty("org.getopt.stempel.table", "/res/tables/stemmer_2000.out"));
    }

    public Stemmer(String string) {
        if (string == null) {
            return;
        }
        this.tableResPath = string;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(this.getClass().getResourceAsStream(this.tableResPath)));
            String string2 = dataInputStream.readUTF().toUpperCase();
            this.stemmer = string2.indexOf(77) < 0 ? new Trie(dataInputStream) : new MultiTrie2(dataInputStream);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.stemmer = null;
        }
    }

    public String getTableResPath() {
        return this.tableResPath;
    }

    public Stemmer(Trie trie) {
        this.stemmer = trie;
    }

    public String stem(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.length() <= this.MIN_LENGTH) {
            return string;
        }
        String string2 = this.stemmer.getLastOnPath(string);
        if (string2 == null) {
            if (bl) {
                return string;
            }
            return null;
        }
        StringBuffer stringBuffer = Diff.apply(new StringBuffer(string), string2);
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        if (bl) {
            return string;
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 1) {
            Stemmer stemmer = new Stemmer(stringArray[0]);
            System.out.println(stemmer.stem(stringArray[1], false));
        } else {
            Stemmer stemmer = new Stemmer();
            System.out.println(stemmer.stem(stringArray[0], false));
        }
    }
}

