/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.stempel.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.getopt.stempel.Stemmer;

public class StempelFilter
extends TokenFilter {
    private Stemmer stemmer = null;

    public StempelFilter(TokenStream tokenStream) {
        super(tokenStream);
        this.stemmer = new Stemmer();
    }

    public StempelFilter(Stemmer stemmer, TokenStream tokenStream) {
        super(tokenStream);
        this.stemmer = stemmer;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        String string = this.stemmer.stem(token.termText(), true);
        if (!string.equals(token.termText())) {
            Token token2 = new Token(string, token.startOffset(), token.endOffset(), token.type());
            token2.setPositionIncrement(token.getPositionIncrement());
            return token2;
        }
        return token;
    }
}

