/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.egothor.stemmer.MultiTrie;
import org.egothor.stemmer.Reduce;
import org.egothor.stemmer.Trie;

public class MultiTrie2
extends MultiTrie {
    public MultiTrie2(DataInput dataInput) throws IOException {
        super(dataInput);
    }

    public MultiTrie2(boolean bl) {
        super(bl);
    }

    public String getFully(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.tries.size() * 2);
        try {
            String string2 = string;
            String[] stringArray = new String[this.tries.size()];
            char c = ' ';
            for (int i = 0; i < this.tries.size(); ++i) {
                String string3 = ((Trie)this.tries.elementAt(i)).getFully(string2);
                if ("*".equalsIgnoreCase(string3) || string3 == null) {
                    return stringBuffer.toString();
                }
                if (this.cannotFollow(c, string3.charAt(0))) {
                    return stringBuffer.toString();
                }
                c = string3.charAt(string3.length() - 2);
                stringArray[i] = string3;
                if (stringArray[i].startsWith("-")) {
                    if (i > 0) {
                        string = this.skip(string, this.lengthPP(stringArray[i - 1]));
                    }
                    string = this.skip(string, this.lengthPP(stringArray[i]));
                }
                stringBuffer.append(string3);
                if (string.length() == 0) continue;
                string2 = string;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public String getLastOnPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.tries.size() * 2);
        try {
            String string2 = string;
            String[] stringArray = new String[this.tries.size()];
            char c = ' ';
            for (int i = 0; i < this.tries.size(); ++i) {
                String string3 = ((Trie)this.tries.elementAt(i)).getLastOnPath(string2);
                if ("*".equalsIgnoreCase(string3) || string3 == null) {
                    return stringBuffer.toString();
                }
                if (this.cannotFollow(c, string3.charAt(0))) {
                    return stringBuffer.toString();
                }
                c = string3.charAt(string3.length() - 2);
                stringArray[i] = string3;
                if (stringArray[i].startsWith("-")) {
                    if (i > 0) {
                        string = this.skip(string, this.lengthPP(stringArray[i - 1]));
                    }
                    string = this.skip(string, this.lengthPP(stringArray[i]));
                }
                stringBuffer.append(string3);
                if (string.length() == 0) continue;
                string2 = string;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public void store(DataOutput dataOutput) throws IOException {
        super.store(dataOutput);
    }

    public void add(String string, String string2) {
        if (string2.length() == 0) {
            return;
        }
        String[] stringArray = this.decompose(string2);
        int n = stringArray.length;
        while (n >= this.tries.size()) {
            this.tries.addElement(new Trie(this.forward));
        }
        String string3 = string;
        for (int i = 0; i < n; ++i) {
            if (string.length() > 0) {
                ((Trie)this.tries.elementAt(i)).add(string, stringArray[i]);
                string3 = string;
            } else {
                ((Trie)this.tries.elementAt(i)).add(string3, stringArray[i]);
            }
            if (!stringArray[i].startsWith("-")) continue;
            if (i > 0) {
                string = this.skip(string, this.lengthPP(stringArray[i - 1]));
            }
            string = this.skip(string, this.lengthPP(stringArray[i]));
        }
        if (string.length() > 0) {
            ((Trie)this.tries.elementAt(n)).add(string, "*");
        } else {
            ((Trie)this.tries.elementAt(n)).add(string3, "*");
        }
    }

    public String[] decompose(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (0 <= n3 && n3 < string.length()) {
            n = this.dashEven(string, n3);
            if (n3 == n) {
                ++n2;
                n3 = n + 2;
                continue;
            }
            ++n2;
            n3 = n;
        }
        String[] stringArray = new String[n2];
        n = 0;
        int n4 = 0;
        while (0 <= n4 && n4 < string.length()) {
            int n5 = this.dashEven(string, n4);
            if (n4 == n5) {
                stringArray[n++] = string.substring(n4, n4 + 2);
                n4 = n5 + 2;
                continue;
            }
            stringArray[n++] = n5 < 0 ? string.substring(n4) : string.substring(n4, n5);
            n4 = n5;
        }
        return stringArray;
    }

    public Trie reduce(Reduce reduce) {
        Trie trie;
        Vector<Trie> vector = new Vector<Trie>();
        Enumeration enumeration = this.tries.elements();
        while (enumeration.hasMoreElements()) {
            trie = (Trie)enumeration.nextElement();
            vector.addElement(trie.reduce(reduce));
        }
        trie = new MultiTrie2(this.forward);
        ((MultiTrie2)trie).tries = vector;
        return trie;
    }

    private boolean cannotFollow(char c, char c2) {
        switch (c) {
            case '-': 
            case 'D': {
                return c == c2;
            }
        }
        return false;
    }

    private String skip(String string, int n) {
        if (this.forward) {
            return string.substring(n);
        }
        return string.substring(0, string.length() - n);
    }

    private int dashEven(String string, int n) {
        while (n < string.length()) {
            if (string.charAt(n) == '-') {
                return n;
            }
            n += 2;
        }
        return -1;
    }

    private int lengthPP(String string) {
        int n = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i++)) {
                case '-': 
                case 'D': {
                    n += string.charAt(i) - 97 + 1;
                    continue block4;
                }
                case 'R': {
                    ++n;
                }
            }
        }
        return n;
    }
}

