/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import org.egothor.stemmer.MultiTrie2;
import org.egothor.stemmer.Trie;

public class Stock {
    Trie stemmer = null;

    public Stock() {
        String string = System.getProperty("default.stemmer");
        if (string == null) {
            return;
        }
        try {
            System.out.println("Default stemmer " + string);
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            String string2 = dataInputStream.readUTF().toUpperCase();
            this.stemmer = string2.indexOf(77) < 0 ? new Trie(dataInputStream) : new MultiTrie2(dataInputStream);
            System.out.println("Default stemmer loaded.");
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.stemmer = null;
        }
    }

    public Trie getStemmer(Locale locale) {
        return this.stemmer;
    }
}

