/*
 * Decompiled with CFR 0.152.
 */
package com.dawidweiss.morfeusz;

import com.dawidweiss.ipipan.corpus.Tag;
import com.dawidweiss.morfeusz.Analyzer;
import com.dawidweiss.morfeusz.InterpMorf;
import com.dawidweiss.morfeusz.Morfeusz;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;

public class MorfeuszDemo {
    private boolean parseTags;

    public void analyze(Reader input, Writer output) throws IOException {
        int token;
        Analyzer analyzer = Morfeusz.getInstance().getAnalyzer();
        int words = 0;
        long start = System.currentTimeMillis();
        StreamTokenizer tokenizer = new StreamTokenizer(input);
        while (-1 != (token = tokenizer.nextToken())) {
            if (token != -3) continue;
            output.write(tokenizer.sval);
            output.write(" ");
            ++words;
            InterpMorf[] analysis = analyzer.analyze(tokenizer.sval);
            if (analysis == null) {
                output.write("?");
            } else {
                for (int j = 0; j < analyzer.getTokensNumber(); ++j) {
                    String part = analysis[j].getTokenImage();
                    String lemma = analysis[j].getLemmaImage();
                    String tag = analysis[j].getTagImage();
                    if (j > 0) {
                        output.write("; ");
                    }
                    output.write(part);
                    output.write(",");
                    output.write(lemma);
                    output.write(",");
                    output.write(tag);
                    if (!this.parseTags) continue;
                    try {
                        Tag.create(tag);
                        continue;
                    }
                    catch (RuntimeException e) {
                        System.err.println("Could not parse tag for: " + tokenizer.sval + " ('" + tag + "'); Error: " + e.toString());
                    }
                }
            }
            output.write("\n");
        }
        input.close();
        output.close();
        long time = System.currentTimeMillis() - start;
        System.err.println("Analyzed: " + words + " words in " + time + " milliseconds.");
        System.err.println((int)((float)words / ((float)time / 1000.0f)) + " words per second.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int i;
        MorfeuszDemo demo = new MorfeuszDemo();
        Reader r = null;
        Writer w = null;
        String encoding = "utf-8";
        try {
            for (i = 0; i < args.length; ++i) {
                if (args[i].equals("-help")) {
                    System.err.println("Arguments: [-version] [-encoding input_stream_encoding] [-parsetags] [input file] [output file]");
                    return;
                }
                if (args[i].equals("-encoding")) {
                    encoding = args[++i];
                    continue;
                }
                if (args[i].equals("-version")) {
                    System.out.println(Morfeusz.getInstance().about());
                    return;
                }
                if (args[i].equals("-parsetags")) {
                    demo.setParseTags(true);
                    continue;
                }
                if (r == null) {
                    System.err.println("Using input characters encoding: " + encoding);
                    r = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(args[i])), encoding);
                    continue;
                }
                if (w != null) {
                    System.err.println("Too many parameters.");
                    return;
                }
                w = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(args[i])), "utf-8");
            }
            if (r == null) {
                System.err.println("Using input characters encoding: " + encoding);
                System.err.println("Reading from standard input.");
                r = new InputStreamReader(System.in, encoding);
            }
            if (w == null) {
                w = new OutputStreamWriter((OutputStream)System.out, "utf-8");
            }
            demo.analyze(r, w);
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Error parsing parameters at: " + args[i - 1]);
            System.err.println("Type '-help' for help.");
            return;
        }
        catch (IOException e) {
            System.err.println("IO Exception: " + e.getMessage());
            return;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void setParseTags(boolean value) {
        this.parseTags = value;
    }
}

