/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd;

import ipipan.spejd.processing.SpejdManagingProcess;
import ipipan.spejd.readers.InputFileFilter;
import ipipan.spejd.util.Config;
import ipipan.spejd.util.DirFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.concurrent.LinkedBlockingQueue;

public class Parser {
    public FileFilter subdirs;
    public FileFilter inputFiles;
    public LinkedBlockingQueue<File> filesToBeProcessed = new LinkedBlockingQueue();

    public Parser(String path, Config conf) {
        this.subdirs = new DirFileFilter();
        this.inputFiles = new InputFileFilter(conf);
        this.lookForFiles(new File(path));
        System.out.println("Found " + this.filesToBeProcessed.size() + " files.");
    }

    public void lookForFiles(File path) {
        File f;
        if (!path.exists()) {
            System.out.println("\n Error: file/directory [" + path.getPath() + "] does not exists.");
            System.exit(0);
        }
        if (!path.isDirectory()) {
            this.filesToBeProcessed.add(path);
            return;
        }
        File[] fileArray = path.listFiles(this.inputFiles);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            this.filesToBeProcessed.add(f);
            ++n2;
        }
        fileArray = path.listFiles(this.subdirs);
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            this.lookForFiles(f);
            ++n2;
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java Parser DIR [OPTIONS]");
            System.exit(1);
        }
        Config conf = new Config("config.ini", args);
        Parser p = new Parser(args[0], conf);
        SpejdManagingProcess smp = new SpejdManagingProcess(p.filesToBeProcessed, conf);
        smp.run();
        System.exit(0);
    }
}

