/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.actions;

import ipipan.spejd.actions.WordBasePart;
import ipipan.spejd.entities.Entity;
import ipipan.spejd.entities.Interpretation;
import ipipan.spejd.rules.Match;
import ipipan.spejd.util.Config;
import java.util.Set;
import java.util.TreeSet;

public class WordActionArg {
    int token;
    WordBasePart[] base;
    String[] interp;
    Config conf;

    public WordActionArg(int token, String tag, WordBasePart[] base, Config conf) {
        this.conf = conf;
        this.token = token - 1;
        this.base = base;
        this.interp = conf.tagset.cToFtagArray(tag);
    }

    public Set<Interpretation> createInterpretations(Match matcher) {
        StringBuilder baseb = new StringBuilder();
        int i = 0;
        while (i < this.base.length) {
            baseb.append(this.base[i].eval(matcher));
            ++i;
        }
        String bases = baseb.toString();
        TreeSet<Interpretation> res = new TreeSet<Interpretation>();
        if (this.token < 0) {
            int j = 0;
            while (j < this.interp.length) {
                res.add(new Interpretation(String.valueOf(this.interp[j]) + bases, this.conf));
                ++j;
            }
        } else {
            Entity e = matcher.getSingle(this.token);
            for (Interpretation i2 : e.getInterpretations()) {
                int j = 0;
                while (j < this.interp.length) {
                    res.add(new Interpretation(i2, this.interp[j], bases, this.conf));
                    ++j;
                }
            }
        }
        return res;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.token >= 0) {
            res.append(this.token);
            res.append(", ");
        }
        int i = 0;
        while (i < this.interp.length) {
            if (i > 0) {
                res.append(" | ");
            }
            res.append(this.interp[i]);
            ++i;
        }
        res.append(',');
        i = 0;
        while (i < this.base.length) {
            res.append(' ');
            res.append(this.base[i].toString());
            ++i;
        }
        return res.toString();
    }
}

