/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.entities;

import ipipan.spejd.tagset.Tagset;
import ipipan.spejd.util.Config;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Interpretation
implements Comparable<Interpretation> {
    String data;
    boolean disamb;
    boolean disambSh;
    protected Config conf = null;
    public static final String REPLACE_BASE = "%";

    public Interpretation(String s, Config conf) {
        this.conf = conf;
        this.data = s;
        this.disamb = false;
        this.disambSh = true;
    }

    public Interpretation(String s, boolean disamb, Config conf) {
        this.conf = conf;
        this.data = s;
        this.disamb = disamb;
        this.disambSh = true;
    }

    public Interpretation(Interpretation interp, String modifier, Config conf) {
        this.conf = conf;
        char[] res = new char[interp.data.length()];
        int i = 0;
        while (i < interp.data.length()) {
            res[i] = i < modifier.length() && modifier.charAt(i) != '0' ? modifier.charAt(i) : interp.data.charAt(i);
            ++i;
        }
        this.data = new String(res);
        this.disamb = interp.disamb;
        this.disambSh = true;
    }

    public Interpretation(Interpretation interp, String modifier, String base, Config conf) {
        this.conf = conf;
        int taglen = conf.tagset.nOfAttributes() - 2;
        char[] res = new char[taglen];
        int i = 0;
        while (i < taglen) {
            res[i] = i < modifier.length() && modifier.charAt(i) != '0' ? modifier.charAt(i) : interp.data.charAt(i);
            ++i;
        }
        Tagset cfr_ignored_0 = conf.tagset;
        Tagset cfr_ignored_1 = conf.tagset;
        String pos = conf.tagset.charToValue(conf.tagset.attrToInt("pos"), res[conf.tagset.attrToInt("pos") - 2]);
        String[] attribs = conf.tagset.getPosByName(pos).getAttributes();
        boolean[] legal = new boolean[taglen];
        int i2 = 0;
        while (i2 < taglen) {
            legal[i2] = false;
            ++i2;
        }
        legal[0] = true;
        i2 = 0;
        while (i2 < attribs.length) {
            legal[conf.tagset.attrToInt((String)attribs[i2]) - 2] = true;
            ++i2;
        }
        i2 = 0;
        while (i2 < taglen) {
            if (!legal[i2]) {
                res[i2] = 48;
            }
            ++i2;
        }
        this.data = String.valueOf(new String(res)) + base.replaceAll(REPLACE_BASE, Matcher.quoteReplacement(interp.data.substring(taglen)));
        this.disamb = interp.disamb;
        this.disambSh = true;
    }

    @Override
    public int compareTo(Interpretation i) {
        return this.data.compareTo(i.data);
    }

    public boolean matches(Pattern pattern) {
        return pattern.matcher(this.data).matches();
    }

    public void delete() {
        this.disambSh = false;
    }

    public void modify(String modifier) {
        char[] res = new char[this.data.length()];
        int i = 0;
        while (i < this.data.length()) {
            res[i] = i < modifier.length() && modifier.charAt(i) != '0' ? modifier.charAt(i) : this.data.charAt(i);
            ++i;
        }
        this.data = new String(res);
    }

    public String getBase() {
        return this.data.substring(this.conf.tagset.nOfAttributes() - 2);
    }

    public void printTxt(StringBuilder res) {
        if (this.disambSh) {
            res.append('<');
            res.append(this.data);
        }
    }

    public void printXML(PrintStream out) {
        int baseIndex = this.conf.tagset.nOfAttributes() - 2;
        if (this.conf.discardDeleted && !this.disambSh) {
            return;
        }
        out.print("<lex");
        if (this.disamb) {
            out.print(" disamb=\"1\"");
        }
        if (!this.disambSh) {
            out.print(" disamb_sh=\"0\"");
        }
        out.print("><base>");
        out.print(this.data.substring(baseIndex));
        out.print("</base><ctag>");
        out.print(this.conf.tagset.fToCtag(this.data.substring(0, baseIndex)));
        out.println("</ctag></lex>");
    }
}

