/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.entities;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.entities.Interpretation;
import ipipan.spejd.processing.ProcessingThread;
import ipipan.spejd.util.Config;
import java.io.PrintStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class Segment
extends Entity {
    String orth;
    Interpretation[] interp;

    public Segment(Config conf) {
        super(conf);
    }

    public Segment(String id, String orth, Interpretation[] interp, Config conf) {
        super(conf);
        this.id = id == null ? ((ProcessingThread)Thread.currentThread()).chunk.getNewId() : id;
        this.type = (char)116;
        this.orth = orth;
        this.interp = interp;
        this.modified = true;
    }

    @Override
    public Set<String> getAttrValues(int[] attrIds, boolean acceptNull) {
        TreeSet<String> res = new TreeSet<String>();
        char[] buf = new char[this.conf.tagset.nOfAttributes() - 2];
        int i = 0;
        while (i < buf.length) {
            buf[i] = 46;
            ++i;
        }
        i = 0;
        while (i < this.interp.length) {
            boolean hasNull = false;
            if (this.interp[i].disambSh) {
                int j = 0;
                while (j < attrIds.length) {
                    int k = attrIds[j] - 2;
                    buf[k] = this.interp[i].data.charAt(k);
                    if (buf[k] < 'A') {
                        hasNull = true;
                    }
                    ++j;
                }
                if (!hasNull || acceptNull) {
                    res.add(new String(buf));
                }
            }
            ++i;
        }
        return res;
    }

    @Override
    public void add(boolean delOld, String[] data) {
        Interpretation[] newInterp = new Interpretation[this.interp.length + data.length];
        int i = 0;
        while (i < this.interp.length) {
            newInterp[i] = this.interp[i];
            if (delOld) {
                newInterp[i].delete();
            }
            ++i;
        }
        int bs = this.conf.tagset.nOfAttributes() - 2;
        String base = this.interp[0].data.substring(bs);
        i = 0;
        while (i < data.length) {
            newInterp[this.interp.length + i] = new Interpretation(data[i].length() > bs ? data[i] : String.valueOf(data[i]) + base, false, this.conf);
            ++i;
        }
        this.interp = newInterp;
        this.modified = true;
    }

    @Override
    public void delete(Pattern pattern, boolean neg) {
        int i = 0;
        while (i < this.interp.length) {
            if (this.interp[i].disambSh) {
                boolean delete = this.interp[i].matches(pattern);
                if (neg) {
                    boolean bl = delete = !delete;
                }
                if (delete) {
                    this.modified = true;
                    this.interp[i].delete();
                }
            }
            ++i;
        }
    }

    @Override
    void updateTxt() {
        StringBuilder res = new StringBuilder();
        res.append("<<t<");
        res.append(this.id);
        res.append('<');
        res.append(this.orth);
        int i = 0;
        while (i < this.interp.length) {
            this.interp[i].printTxt(res);
            ++i;
        }
        res.append('>');
        this.text = res.toString();
        this.modified = false;
    }

    @Override
    public String getAttr(int id) {
        switch (id) {
            case 0: {
                return this.orth;
            }
            case 1: {
                return this.interp[0].data.substring(this.conf.tagset.nOfAttributes() - 2);
            }
        }
        return "";
    }

    @Override
    public Segment getSemHead() {
        return this;
    }

    @Override
    public Segment getSynHead() {
        return this;
    }

    @Override
    public Set<Interpretation> getInterpretations() {
        TreeSet<Interpretation> res = new TreeSet<Interpretation>();
        int i = 0;
        while (i < this.interp.length) {
            if (this.interp[i].disambSh) {
                res.add(this.interp[i]);
            }
            ++i;
        }
        return res;
    }

    @Override
    public Interpretation[] getInterpretationArray() {
        return this.interp;
    }

    void appendData(PrintStream out) {
        out.print("<orth>");
        out.print(this.orth);
        out.println("</orth>");
        int i = 0;
        while (i < this.interp.length) {
            this.interp[i].printXML(out);
            ++i;
        }
    }

    @Override
    public void printXML(PrintStream out) {
        out.print("<tok id=\"");
        out.print(this.id);
        out.print("\">\n");
        this.appendData(out);
        out.println("</tok>");
    }
}

