/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.rules;

import ipipan.spejd.actions.Action;
import ipipan.spejd.rules.Match;
import ipipan.spejd.util.Config;
import ipipan.spejd.util.TimeWatch;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractRule {
    String title;
    Action[] actions;
    int matched;
    int completed;
    TimeWatch timer;
    AtomicLong tmatch;
    AtomicLong taction;
    Config conf;

    public AbstractRule(String title, Action[] actions, Config conf) {
        this.conf = conf;
        this.title = title;
        this.actions = actions;
        int i = 0;
        while (i < actions.length) {
            actions[i].setRule(this);
            ++i;
        }
        this.timer = TimeWatch.getDefaultTimer();
        this.completed = 0;
        this.matched = 0;
        this.tmatch = new AtomicLong(0L);
        this.taction = new AtomicLong(0L);
    }

    public abstract void log(PrintStream var1);

    public boolean applyActions(Match match) {
        boolean modified = false;
        ++this.matched;
        this.timer.getInterval();
        int i = 0;
        while (i < this.actions.length) {
            if (!this.actions[i].apply(match)) break;
            modified = true;
            ++i;
        }
        if (i == this.actions.length) {
            ++this.completed;
        }
        this.taction.addAndGet(this.timer.getInterval());
        return modified;
    }

    public String getTitle() {
        return this.title;
    }

    public void report(PrintStream log) {
        log.println(String.valueOf('\"') + this.title + "\"," + this.completed + "," + this.matched + "," + this.tmatch + "," + this.taction.toString() + "," + (this.tmatch.get() + this.taction.get()));
    }
}

