/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.rules;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.entities.Interpretation;
import ipipan.spejd.util.Config;
import ipipan.spejd.util.SimpleDict;

public class LexDictionary
extends SimpleDict {
    int lex = 0;
    int tok = 0;
    private Config conf;

    public LexDictionary(String filename, Config conf) {
        super(filename);
        this.conf = conf;
        this.load(filename);
    }

    @Override
    public void put(String var, String value) {
        if (!this.dict.containsKey(var)) {
            if (this.conf == null) {
                System.out.println("conf=null value=" + value + " for var=" + var);
            }
            this.dict.put(var, this.conf.tagset.cToFtag(value));
        } else {
            System.out.println("LexDictionary already contains word " + var + ".");
        }
    }

    public void apply(Entity e) {
        if (this.dict.size() == 0) {
            return;
        }
        Interpretation[] interp = e.getInterpretationArray();
        if (interp == null) {
            return;
        }
        boolean modified = false;
        int i = 0;
        while (i < interp.length) {
            String tag = (String)this.dict.get(interp[i].getBase());
            if (tag != null) {
                interp[i].modify(tag);
                ++this.lex;
                modified = true;
            }
            ++i;
        }
        if (modified) {
            ++this.tok;
        }
    }

    public void report() {
        System.out.println("LexDictionary matches: " + this.tok + " (" + this.lex + ")");
    }
}

